#pragma once

#include <infra/pod_agent/libs/path_util/path_holder.h>
#include <infra/pod_agent/libs/push_client/utils/push_client_types.h>

namespace NInfra::NPodAgent {

class ILogsTransmitter;

using TLogsTransmitterPtr = TIntrusivePtr<ILogsTransmitter>;

class ILogsTransmitter: public TAtomicRefCount<ILogsTransmitter> {
public:
    virtual void TransmitLogs(const THashSet<TPushContainer>& pushContainers) = 0;
    virtual ~ILogsTransmitter() = default;
};

} //namespace NInfra::NPodAgent
