#pragma once

#include "logs_transmitter.h"

#include <infra/pod_agent/libs/pod_agent/logs_transmitter/holders/file_stream_holder_impl.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/holders/holders_context.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/holders/logs_file_offset_holder_impl.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/statistics/logs_transmitter_statistics.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/utils/logs_transmitter_utils.h>
#include <infra/pod_agent/libs/porto_client/client.h>
#include <infra/pod_agent/libs/porto_client/property.h>
#include <infra/pod_agent/libs/push_client/client.h>

namespace NInfra::NPodAgent {

class TLogsTransmitterImpl;

using TSimpleLogsTransmitterPtr = TIntrusivePtr<TLogsTransmitterImpl>;

class TLogsTransmitterImpl: public ILogsTransmitter {
public:
    TLogsTransmitterImpl(
        THoldersContextPtr holdersContext,
        TPushClientPtr simpleClient,
        TLogFramePtr logFrame,
        TLogsTransmitterStatisticsPtr statistics
    );

    void TransmitLogs(const THashSet<TPushContainer>& pushContainers) override;

private:
    TPushEvents GetEvents(const THashSet<TPushContainer>& pushContainers);
    TExpected<TPushEventConstPtr, TPushClientError> GetEvent(const TPushContainer& pushContainer);
    void SendEvents(const TPushEvents& pushEvents);

private:
    THoldersContextPtr HoldersContext_;
    TPushClientPtr SimpleClient_;
    TLogFramePtr LogFrame_;
    TLogsTransmitterStatisticsPtr Statistics_;
};

} //namespace NInfra::NPodAgent
