#pragma once

#include "logs_transmitter_impl.h"
#include "logs_transmitter_multithread.h"
#include "logs_transmitter_porto_offsets_checker.h"

#include <infra/pod_agent/libs/pod_agent/logs_transmitter/holders/holders_context.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/holders/holders_updater.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/holders/session_holder_impl.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/statistics/logs_transmitter_statistics_printer_impl.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/utils/active_containers_getter.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/utils/need_transmit_logs_detector.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/filter/processed_containers_filter.h>

#include <infra/pod_agent/libs/path_util/path_holder.h>
#include <infra/pod_agent/libs/pod_agent/period_job_worker/period_job.h>
#include <infra/pod_agent/libs/push_client/client.h>

#include <util/system/rwlock.h>

namespace NInfra::NPodAgent {

class TLogsTransmitterJob;
using TLogsTransmitterJobPtr = TIntrusivePtr<TLogsTransmitterJob>;

class TLogsTransmitterJob: public IPeriodJob {
public:
    TLogsTransmitterJob(
        const TDuration& period
        , THoldersContextPtr stdoutHoldersContext
        , THoldersContextPtr stderrHoldersContext
        , TLogsTransmitterPtr stdoutLogsTransmitter
        , TLogsTransmitterPtr stderrLogsTransmitter
        , TLogFramePtr logFrame
        , TLogFramePtr periodWorkerEventsLogFrame
        , TPathHolderPtr pathHolder
        , THoldersUpdaterPtr holdersUpdater
        , TFilterPtr processedContainersFilter
        , TFilterPtr portoExistsContainersFilter
        , TNeedTransmitLogsDetectorPtr needTransmitLogsDetector
        , TActiveContainersGetterPtr activeContainersGetter
        , TLogsTransmitterStatisticsPrinterPtr statisticsPrinter
        , TLogsTransmitterPortoOffsetsCheckerPtr portoStdoutOffsetsChecker
        , TLogsTransmitterPortoOffsetsCheckerPtr portoStderrOffsetsChecker
        , TPortoClientPtr porto
        , TFileSystemUtilsPtr fileSystemUtils
        , ui32 jobRunsCountBetweenOffsetsSerialization
        , const THashSet<TPushContainer>& initPushContainers = {} //need for tests
    );

    void Run() override;
    void Shutdown() override;
    void Initialize();
private:
    void SerializeContainersLogFilesOffsets(const THashSet<TPushContainer>& pushContainers);
    void DeserializeContainersLogFilesOffsets(const THashSet<TPushContainer>& pushContainers);

private:
    void TryRotateContainersLogFiles(const THashSet<TPushContainer>& pushContainers);
    void TryRotateContainerLogFiles(THoldersContextPtr holdersContext, const TPushContainer& pushContainer);

private:
    THoldersContextPtr StdoutHoldersContext_;
    THoldersContextPtr StderrHoldersContext_;
    TLogsTransmitterPtr StdoutLogsTransmitter_;
    TLogsTransmitterPtr StderrLogsTransmitter_;
    TLogFramePtr LogFrame_;
    TPathHolderPtr PathHolder_;
    THoldersUpdaterPtr HoldersUpdater_;
    TFilterPtr ProcessedContainersFilter_;
    TFilterPtr PortoExistsContainersFilter_;
    TNeedTransmitLogsDetectorPtr NeedTransmitLogsDetector_;
    TActiveContainersGetterPtr ActiveContainersGetter_;
    TLogsTransmitterStatisticsPrinterPtr StatisticsPrinter_;
    TLogsTransmitterPortoOffsetsCheckerPtr PortoStdoutOffsetsChecker_;
    TLogsTransmitterPortoOffsetsCheckerPtr PortoStderrOffsetsChecker_;
    TPortoClientPtr Porto_;
    TFileSystemUtilsPtr FileSystemUtils_;
    ui32 JobRunsCountBetweenOffsetsSerialization_;
    ui32 RunsAfterLastOffsetSerialization_ = 0;

    THashSet<TPushContainer> PushContainers_;
};


} // namespace NInfra::NPodAgent
