#pragma once

#include "logs_transmitter_job.h"

#include <infra/libs/logger/log_frame.h>
#include <infra/pod_agent/libs/config/config.pb.h>
#include <infra/pod_agent/libs/path_util/path_holder.h>
#include <infra/pod_agent/libs/pod_agent/period_job_worker/period_job.h>
#include <infra/pod_agent/libs/pod_agent/status_and_ticker_holder/status_and_ticker_holder.h>
#include <infra/pod_agent/libs/porto_client/client.h>

namespace NInfra::NPodAgent {

class TLogsTransmitterJobFactory {
public:
    TLogsTransmitterJobFactory(
        const TConfig& config
        , TLogFramePtr logFrame
        , TLogFramePtr jobPeriodWorkerEventsLogFrame
        , TPathHolderPtr pathHolder
        , const TString& hostName
        , TStatusRepositoryPtr statusRepository
        , TStatusNTickerHolderPtr statusNTickerHolder
        , TPortoClientPtr portoClient
        , const bool isBoxAgentMode
    );

    TLogsTransmitterJobPtr Create();

private:
    TPushSessionFactoryPtr CreatePushSessionFactory(const ELogType& logType);

private:
    static constexpr const i32 NUM_OF_LOG_TYPES = 2;
    static const i32 STATISTICS_PRINTER_INVOKATION_PERIOD_SEC = 5;
    static const i32 PORTO_OFFSET_CHECKER_INVOKATION_PERIOD_SEC = 5;
    static constexpr const i32 MIN_LOGS_TRANSMITTER_JOB_RUNS_BETWEEN_OFFSETS_SERIALIZATIONS = 10;

    const TConfig Config_;
    TLogFramePtr LogFrame_;
    TLogFramePtr JobPeriodWorkerEventsLogFrame_;
    TPathHolderPtr PathHolder_;
    const TString HostName_;
    TAtomicSharedPtr<IThreadPool> MtpQueue_;
    TStatusRepositoryPtr StatusRepository_;
    TStatusNTickerHolderPtr StatusNTickerHolder_;
    TPortoClientPtr PortoClient_;
    const bool IsBoxAgentMode_;
};

} // namespace NInfra::NPodAgent
