#pragma once

#include "logs_transmitter_impl.h"

namespace NInfra::NPodAgent{

class TLogsTransmitterMultithread;

using TLogsTransmitterMultithreadPtr = TIntrusivePtr<TLogsTransmitterMultithread>;

class TLogsTransmitterMultithread : public ILogsTransmitter {
public:
    TLogsTransmitterMultithread(ui32 numOfThreads, TLogsTransmitterPtr logsTransmitter, TAtomicSharedPtr<IThreadPool> mtpQueue, TLogFramePtr logFrame);
    void TransmitLogs(const THashSet<TPushContainer>& pushContainers) override;

    // Public for testing
    static TVector<THashSet<TPushContainer>> Split(const THashSet<TPushContainer>& pushContainers, const ui32 numOfThreads);

private:
    const ui32 NumOfThreads_;
    TLogsTransmitterPtr LogsTransmitter_;
    TAtomicSharedPtr<IThreadPool> MtpQueue_;
    TLogFramePtr LogFrame_;
};

}
