#pragma once

#include <infra/pod_agent/libs/push_client/utils/push_client_types.h>

#include <util/generic/hash_set.h>
#include <util/generic/ptr.h>

namespace NInfra::NPodAgent {

class ILogsTransmitterPortoOffsetsChecker;

using TLogsTransmitterPortoOffsetsCheckerPtr = TIntrusivePtr<ILogsTransmitterPortoOffsetsChecker>;

class ILogsTransmitterPortoOffsetsChecker: public TAtomicRefCount<ILogsTransmitterPortoOffsetsChecker> {
public:
    virtual void Check(const THashSet<TPushContainer>& pushContainers) = 0;
    virtual ~ILogsTransmitterPortoOffsetsChecker() = default;
};

} //namespace NInfra::NPodAgent
