#pragma once

#include "logs_transmitter_porto_offsets_checker.h"

#include <infra/libs/logger/log_frame.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/holders/holders_context.h>
#include <infra/pod_agent/libs/porto_client/client.h>

namespace NInfra::NPodAgent {

class TLogsTransmitterPortoOffsetsCheckerImpl;

using TLogsTransmitterPortoOffsetsCheckerImplPtr = TIntrusivePtr<TLogsTransmitterPortoOffsetsCheckerImpl>;

class TLogsTransmitterPortoOffsetsCheckerImpl: public ILogsTransmitterPortoOffsetsChecker {

public:
    TLogsTransmitterPortoOffsetsCheckerImpl(
         TPortoClientPtr portoClient
         , THoldersContextPtr holdersContext
         , TLogFramePtr logFrame
         , ui32 checkPeriodSec
         , EPortoContainerProperty offsetTypeProperty
         , EPortoContainerProperty streamPathProperty
         , std::function<void(THoldersContextPtr, const TPushContainer&, ui64, TLogFramePtr)> portoRotatedDataHandler
    );

    void Check(const THashSet<TPushContainer>& pushContainers) override;

private:
    static bool IsPortoLogFile(const TString& streamPath);
    std::variant<TEmptySuccess, TPortoError, TPushClientError> CheckContainer(const TPushContainer&);

private:
    ui64 LastCheckTime_;
    TPortoClientPtr PortoClient_;
    THoldersContextPtr HoldersContext_;
    TLogFramePtr LogFrame_;
    ui32 CheckPeriodSec_;
    EPortoContainerProperty OffsetTypeProperty_;
    EPortoContainerProperty StreamPathProperty_;
    std::function<void(THoldersContextPtr, const TPushContainer&, ui64, TLogFramePtr)> PortoRotatedDataHandler_;
};

} //namespace NInfra::NPodAgent
