#include "infra/pod_agent/libs/pod_agent/logs_transmitter/utils/logs_transmitter_utils.h"
#include "porto_rotated_handlers_context.h"

namespace NInfra::NPodAgent {

/*
    When porto rotated logs file while pod_agent restarting, we need decrement logs file offset in holder and update porto offset
    Let porto rotated N bytes and we have logs file offset M.
    We have 2 cases:
        1. if N <= M: we need decrease logs file offset by N;
        2. if N > M: we need set 0 in logs file offset
*/
TPortoRotatedHandlersContext::TPortoRotatedHandlerFunction TPortoRotatedHandlersContext::GetPortoRotatedOnStartHandler() {
    return [](
        THoldersContextPtr holdersContext
        , const TPushContainer& container
        , ui64 newPortoOffset
        , TLogFramePtr logFrame
    ) {
        auto portoOffsetGetResult = holdersContext->GetPortoOffsetHolder()->GetOffset(container);
        if (!portoOffsetGetResult) {
            logFrame->LogEvent(TLOG_ERR, NLogsTransmitterUtils::ConstructExceptionEvent(portoOffsetGetResult.Error()));
            return;
        }

        auto fileOffsetGetResult = holdersContext->GetLogsFileOffsetHolder()->GetOffset(container);
        if (!fileOffsetGetResult) {
            logFrame->LogEvent(TLOG_ERR, NLogsTransmitterUtils::ConstructExceptionEvent(fileOffsetGetResult.Error()));
            return;
        }

        ui64 oldPortoOffset = portoOffsetGetResult.Success();
        ui64 bytesPortoRotated = newPortoOffset - oldPortoOffset;

        ui64 oldFileOffset = fileOffsetGetResult.Success();
        ui64 decrementDeltaFileOffset = bytesPortoRotated < oldFileOffset ? bytesPortoRotated : oldFileOffset;

        auto portoOffsetUpdateResult = holdersContext->GetPortoOffsetHolder()->UpdateOffset(container, newPortoOffset);
        if (!portoOffsetUpdateResult) {
            logFrame->LogEvent(TLOG_ERR, NLogsTransmitterUtils::ConstructExceptionEvent(portoOffsetUpdateResult.Error()));
        }

        auto fileOffsetDecrementResult = holdersContext->GetLogsFileOffsetHolder()->DecrementOffset(container, decrementDeltaFileOffset);
        if (!fileOffsetDecrementResult) {
            logFrame->LogEvent(TLOG_ERR, NLogsTransmitterUtils::ConstructExceptionEvent(fileOffsetDecrementResult.Error()));
        }
    };
}

TPortoRotatedHandlersContext::TPortoRotatedHandlerFunction TPortoRotatedHandlersContext::GetPortoRotatedOnPeriodicCheckHandler() {
    return [](
        THoldersContextPtr holdersContext
        , const TPushContainer& container
        , ui64 offset
        , TLogFramePtr logFrame
    ) {
        auto updateResult = holdersContext->GetPortoOffsetHolder()->UpdateOffset(container, offset);
        if (!updateResult) {
            logFrame->LogEvent(TLOG_ERR, NLogsTransmitterUtils::ConstructExceptionEvent(updateResult.Error()));
        }
    };
}

} //namespace NInfra::NPodAgent
