#pragma once

#include <util/generic/ptr.h>
#include <infra/pod_agent/libs/porto_client/porto_types.h>
#include <infra/pod_agent/libs/push_client/utils/push_client_types.h>

namespace NInfra::NPodAgent {

class IDeserializer;
using TDeserializerPtr = TIntrusivePtr<IDeserializer>;

class IDeserializer: public TAtomicRefCount<IDeserializer> {
public:
    virtual void Deserialize(const TPushContainer& container, ui64& value) = 0;
    virtual ~IDeserializer() = default;
};

} //namespace NInfra::NPodAgent
