#include "file_deserializer.h"

#include <infra/pod_agent/libs/pod_agent/cache_file/cache_file.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/utils/logs_transmitter_utils.h>

#include <library/cpp/protobuf/json/json2proto.h>

#include <util/stream/file.h>
#include <util/system/fs.h>

namespace NInfra::NPodAgent {

TFileDeserializer::TFileDeserializer(
    TPathHolderPtr pathHolder
    , const ELogType& logType
    , TLogFramePtr logFrame
    , TFileSystemUtilsPtr fileSystemUtils
    , std::function<ui64(TContainerMetadata)> metadataGetPropertyCall
)
    : PathHolder_(pathHolder)
    , LogType_(logType)
    , LogFrame_(logFrame)
    , FileSystemUtils_(fileSystemUtils)
    , MetadataGetPropertyCall_(metadataGetPropertyCall)
{}

void TFileDeserializer::Deserialize(const TPushContainer& container, ui64& value) {
    try {
        TString filePath = NLogsTransmitterUtils::GetMetadataFilePath(PathHolder_, container, LogType_);
        if (!FileSystemUtils_->Exists(filePath)) {
            return;
        }

        TContainerMetadata meta = NCacheFile::LoadFromFileJson<TContainerMetadata>(filePath);
        value = MetadataGetPropertyCall_(meta);

    } catch(yexception) {
        LogFrame_->LogEvent(TLOG_ERR, NLogsTransmitterUtils::ConstructExceptionEvent(
            TPushClientError {
                EPushClientError::DeserializeError
                , TStringBuilder() << "Throwed exception while deserializing metadata for container " << container.Container << ": " << CurrentExceptionMessage()
            }
        ));
    }
}

} //namespace NInfra::NPodAgent
