#pragma once

#include "deserializer.h"

#include <infra/libs/logger/log_frame.h>
#include <infra/pod_agent/libs/path_util/path_holder.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/serialize_utils/protos/container_metadata.pb.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/utils/file_system_utils.h>

namespace NInfra::NPodAgent {

class TFileDeserializer: public IDeserializer {
public:
    TFileDeserializer(
        TPathHolderPtr pathHolder
        , const ELogType& logType
        , TLogFramePtr logFrame
        , TFileSystemUtilsPtr fileSystemUtils
        , std::function<ui64(TContainerMetadata)> metadataGetPropertyCall
    );

    void Deserialize(const TPushContainer& container, ui64& value) override;

private:
    TPathHolderPtr PathHolder_;
    ELogType LogType_;
    TLogFramePtr LogFrame_;
    TFileSystemUtilsPtr FileSystemUtils_;
    std::function<ui64(TContainerMetadata)> MetadataGetPropertyCall_;
};

} //namespace NInfra::NPodAgent
