#include "file_serializer.h"

#include <infra/pod_agent/libs/pod_agent/cache_file/cache_file.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/utils/logs_transmitter_utils.h>

#include <library/cpp/protobuf/json/json2proto.h>
#include <library/cpp/protobuf/json/proto2json.h>

#include <util/stream/file.h>

namespace NInfra::NPodAgent {

TFileSerializer::TFileSerializer(
    TPathHolderPtr pathHolder
    , const ELogType& logType
    , TLogFramePtr logFrame
    , TFileSystemUtilsPtr fileSystemUtils
    , std::function<TContainerMetadata(TContainerMetadata, ui64)> metadataSetPropertyCall
)
    : PathHolder_(pathHolder)
    , LogType_(logType)
    , LogFrame_(logFrame)
    , FileSystemUtils_(fileSystemUtils)
    , MetadataSetPropertyCall_(metadataSetPropertyCall)
{}

void TFileSerializer::Serialize(const TPushContainer& container, ui64 value) {
    try {
        TString filePath = NLogsTransmitterUtils::GetMetadataFilePath(PathHolder_, container, LogType_);

        TContainerMetadata meta;
        if (FileSystemUtils_->Exists(filePath)) {
            meta = NCacheFile::LoadFromFileJson<TContainerMetadata>(filePath);
        }

        meta = MetadataSetPropertyCall_(meta, value);

        NCacheFile::SaveToFileJson(filePath, meta);

    } catch(yexception) {
        LogFrame_->LogEvent(TLOG_ERR, NLogsTransmitterUtils::ConstructExceptionEvent(
            TPushClientError{
                EPushClientError::DeserializeError
                , TStringBuilder() << "Throwed exception while serializing metadata for container " << container.Container << ": " << CurrentExceptionMessage()
            }
        ));
    }
}

} //namespace NInfra::NPodAgent
