#include "file_serializer.h"

#include <infra/pod_agent/libs/pod_agent/logs_transmitter/utils/file_system_utils_mock.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/utils/logs_transmitter_utils.h>
#include <library/cpp/testing/unittest/registar.h>
#include <util/stream/file.h>
#include <util/system/fs.h>

namespace NInfra::NPodAgent {

static TLogger logger({});

static TPathHolderPtr pathHolder = new TPathHolder(
    ""
    , {{"", ""}}
    , {{"", ""}}
    , ""
    , ""
    , ""
    , ""
    , ""
    , ""
);
static const TPushContainer defaultContainer = {{{"box"}, "workload"}, "box", "workload"};
static const int serializableValue = 10;
static std::function<TContainerMetadata(TContainerMetadata, ui64)> defaultFunc =
    [](TContainerMetadata meta, ui64 value) {
        meta.set_file_offset(value);
       return meta;
    };

struct TTestFileSystemUtils: public TMockFileSystemUtils {
    bool Exists(const TString&) const override {
        ++ExistsCalls;
        return true;
    }

    mutable size_t MakeDirectoryCalls = 0;
    mutable size_t ExistsCalls = 0;
};

Y_UNIT_TEST_SUITE(FileSerializerSuite) {

    Y_UNIT_TEST(RealSerializeOkTest) {
        TFileSystemUtilsPtr fileSystemUtils = new TFileSystemUtils;
        TSerializerPtr fileSerializer = new TFileSerializer(pathHolder, ELogType::Stdout, logger.SpawnFrame(), fileSystemUtils, defaultFunc);
        NFs::MakeDirectoryRecursive(pathHolder->GetWorkloadLogsMetaPathAtLogsVolumePath());

        fileSerializer->Serialize(defaultContainer, serializableValue);

        TString filePath = NLogsTransmitterUtils::GetMetadataFilePath(pathHolder, defaultContainer, ELogType::Stdout);
        TUnbufferedFileInput stream(filePath);
        TString resultJson = stream.ReadAll();

        UNIT_ASSERT_EQUAL(TStringBuilder() << "{\n  \"file_offset\":" << serializableValue << "\n}", resultJson);
    }
}

} //namespace NInfra::NPodAgent
