#include "porto_deserializer.h"

#include <infra/pod_agent/libs/pod_agent/logs_transmitter/utils/logs_transmitter_utils.h>

namespace NInfra::NPodAgent {

TPortoDeserializer::TPortoDeserializer(
    TPortoClientPtr porto
    , EPortoContainerProperty property
    , TLogFramePtr logFrame
)
    : Porto_(porto)
    , Property_(property)
    , LogFrame_(logFrame)
{}

void TPortoDeserializer::Deserialize(const TPushContainer& container, ui64& value) {
    auto getResult = Porto_->GetProperty(container.Container, Property_);

    if (getResult) {
        value = FromString<ui64>(getResult.Success());
    } else if (getResult.Error().Code == EPortoError::ContainerDoesNotExist) {
        LogFrame_->LogEvent(ELogPriority::TLOG_WARNING, NLogsTransmitterUtils::ConstructExceptionEvent(getResult.Error()));
    } else if (getResult.Error().Code != EPortoError::LabelNotFound) {
        LogFrame_->LogEvent(ELogPriority::TLOG_ERR, NLogsTransmitterUtils::ConstructExceptionEvent(getResult.Error()));
    }
}

} //namespace NInfra::NPodAgent
