#include "porto_deserializer.h"

#include <infra/pod_agent/libs/porto_client/mock_client.h>
#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent {

static TLogger logger({});

static const TString defaultPropertyValue = "123";

struct TTestPortoClient: public TMockPortoClient {

    TExpected<TString, TPortoError> GetProperty(const TPortoContainerName&, EPortoContainerProperty, int) override {
        ++GetPropertyCalls;
        return defaultPropertyValue;
    }

    size_t GetPropertyCalls = 0;
};

Y_UNIT_TEST_SUITE(PortoDeserializerSuite) {

    Y_UNIT_TEST(DeserializeOkTest) {
        TDeserializerPtr portoDeserializer = new TPortoDeserializer(new TTestPortoClient, EPortoContainerProperty::CachedStdoutPortoOffset, logger.SpawnFrame());
        ui64 value = 0;

        portoDeserializer->Deserialize({}, value);
        UNIT_ASSERT_EQUAL(FromString<ui64>(defaultPropertyValue), value);
    }

    Y_UNIT_TEST(DeserializeFailWhenGetPropertyReturnsErrorOkTest) {
        struct TTestPortoClientFails: public TTestPortoClient {
            TExpected<TString, TPortoError> GetProperty(const TPortoContainerName&, EPortoContainerProperty, int) override {
                ++GetPropertyCalls;
                return TPortoError{};
            }
        };

        TDeserializerPtr portoDeserializer = new TPortoDeserializer(new TTestPortoClientFails, EPortoContainerProperty::CachedStdoutPortoOffset, logger.SpawnFrame());
        ui64 value = 0;

        portoDeserializer->Deserialize({}, value);
        UNIT_ASSERT_EQUAL(0, value);
    }
}

} //namespace NInfra::NPodAgent
