#include "porto_serializer.h"

#include <infra/pod_agent/libs/pod_agent/logs_transmitter/utils/logs_transmitter_utils.h>

namespace NInfra::NPodAgent {

TPortoSerializer::TPortoSerializer(
    TPortoClientPtr porto
    , EPortoContainerProperty property
    , TLogFramePtr logFrame
)
    : Porto_(porto)
    , Property_(property)
    , LogFrame_(logFrame)
{}

void TPortoSerializer::Serialize(const TPushContainer& container, ui64 value) {
    auto setResult = Porto_->SetProperty(container.Container, Property_, ToString(value));
    if (!setResult && (EPortoError::ContainerDoesNotExist != setResult.Error().Code)) {
        LogFrame_->LogEvent(ELogPriority::TLOG_ERR, NLogsTransmitterUtils::ConstructExceptionEvent(setResult.Error()));
    }
}

} //namespace NInfra::NPodAgent
