#pragma once

#include <util/generic/ptr.h>
#include <infra/pod_agent/libs/porto_client/porto_types.h>
#include <infra/pod_agent/libs/push_client/utils/push_client_types.h>

namespace NInfra::NPodAgent {

class ISerializer;
using TSerializerPtr = TIntrusivePtr<ISerializer>;

class ISerializer: public TAtomicRefCount<ISerializer> {
public:
    virtual void Serialize(const TPushContainer& container, ui64 value) = 0;
    virtual ~ISerializer() = default;
};

} //namespace NInfra::NPodAgent
