#pragma once

#include <util/generic/ptr.h>

namespace NInfra::NPodAgent {

class ILogsTransmitterStatistics;

using TLogsTransmitterStatisticsPtr = TIntrusivePtr<ILogsTransmitterStatistics>;

class ILogsTransmitterStatistics : public TAtomicRefCount<ILogsTransmitterStatistics> {
public:
    virtual void AddNumRawBytesSent(ui64 numOfBytes) = 0;
    virtual ui64 GetNumRawBytesSent() const = 0;

    virtual void AddNumWrappedBytesSent(ui64 numOfBytes) = 0;
    virtual ui64 GetNumWrappedBytesSent() const = 0;

    virtual void AddNumBytesRotated(ui64 numOfBytes) = 0;
    virtual ui64 GetNumBytesRotated() const = 0;

    virtual void AddNumBytesRotatedByPorto(ui64 numOfBytes) = 0;
    virtual ui64 GetNumBytesRotatedByPorto() const = 0;

    virtual void SessionActivationErrorOccured() = 0;
    virtual ui64 GetNumOfSessionActivationErrors() const = 0;

    virtual void ErrorFromPushAgentOccured() = 0;
    virtual ui64 GetNumErrorsFromPushAgent() const = 0;

    virtual void Reset() = 0;

    virtual ~ILogsTransmitterStatistics() = default;
};

} //namespace NInfra::NPodAgent
