#pragma once

#include "logs_transmitter_statistics.h"

#include <infra/pod_agent/libs/multi_unistat/multi_unistat.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/utils/logs_transmitter_utils.h>
#include <infra/pod_agent/libs/push_client/utils/push_client_types.h>

namespace NInfra::NPodAgent {

class TLogsTransmitterStatisticsImpl : public ILogsTransmitterStatistics {
public:
    TLogsTransmitterStatisticsImpl()
    : NumRawBytesSent_{0}
    , NumWrappedBytesSent_{0}
    , NumBytesRotated_{0}
    , NumBytesRotatedByPorto_{0}
    , SessionActivationErrors_{0}
    , NumOfErrorsFromPushAgent_{0}
    {}

    void AddNumRawBytesSent(ui64 numOfBytes) override {
        AtomicAdd(NumRawBytesSent_, numOfBytes);
    }

    ui64 GetNumRawBytesSent() const override {
        return AtomicGet(NumRawBytesSent_);
    }

    void AddNumWrappedBytesSent(ui64 numOfBytes) override {
        AtomicAdd(NumWrappedBytesSent_, numOfBytes);
    }

    ui64 GetNumWrappedBytesSent() const override {
        return AtomicGet(NumWrappedBytesSent_);
    }

    void AddNumBytesRotated(ui64 numOfBytes) override {
        AtomicAdd(NumBytesRotated_, numOfBytes);
    }

    ui64 GetNumBytesRotated() const override {
        return AtomicGet(NumBytesRotated_);
    }

    void AddNumBytesRotatedByPorto(ui64 numOfBytes) override {
        AtomicAdd(NumBytesRotatedByPorto_, numOfBytes);
    }

    ui64 GetNumBytesRotatedByPorto() const override {
        return AtomicGet(NumBytesRotatedByPorto_);
    }

    void SessionActivationErrorOccured() override {
        AtomicIncrement(SessionActivationErrors_);
    }
    ui64 GetNumOfSessionActivationErrors() const override {
        return AtomicGet(SessionActivationErrors_);
    }

    void ErrorFromPushAgentOccured() override {
        AtomicIncrement(NumOfErrorsFromPushAgent_);
    }
    ui64 GetNumErrorsFromPushAgent() const override {
        return AtomicGet(NumOfErrorsFromPushAgent_);
    }

    virtual void Reset() override {
        AtomicSet(NumRawBytesSent_, 0);
        AtomicSet(NumWrappedBytesSent_, 0);
        AtomicSet(NumBytesRotated_, 0);
        AtomicSet(NumBytesRotatedByPorto_, 0);
        AtomicSet(SessionActivationErrors_, 0);
        AtomicSet(NumOfErrorsFromPushAgent_, 0);
    }

private:
    TAtomic NumRawBytesSent_;
    TAtomic NumWrappedBytesSent_;
    TAtomic NumBytesRotated_;
    TAtomic NumBytesRotatedByPorto_;
    TAtomic SessionActivationErrors_;
    TAtomic NumOfErrorsFromPushAgent_;
};

} //namespace NInfra::NPodAgent
