#pragma once

#include "logs_transmitter_statistics.h"
#include "logs_transmitter_statistics_printer.h"

#include <infra/libs/logger/log_frame.h>

#include <infra/pod_agent/libs/multi_unistat/multi_unistat.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/holders/file_stream_holder.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/holders/session_holder.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/utils/logs_transmitter_utils.h>

#include <util/generic/ptr.h>

namespace NInfra::NPodAgent {

class TLogsTransmitterStatisticsPrinterImpl;

using TLogsTransmitterStatisticsPrinterImplPtr = TIntrusivePtr<TLogsTransmitterStatisticsPrinterImpl>;

class TLogsTransmitterStatisticsPrinterImpl: public ILogsTransmitterStatisticsPrinter {

public:
    TLogsTransmitterStatisticsPrinterImpl(TLogsTransmitterStatisticsPtr statistics, TSessionHolderPtr stdoutSessionHolder, TSessionHolderPtr stderrSessionHolder, TFileStreamHolderPtr stdoutFileStreamHolder, TFileStreamHolderPtr stderrFileStreamHolder, TLogFramePtr logFrame, ui32 printPeriodSec);

    void Print() override;

private:
    static constexpr const char* COUNTER_LOST_LOGS_ROTATED_BY_POD_AGENT = "pod_agent_logs_transmitter_lost_logs_rotated_by_pod_agent";
    static constexpr const char* COUNTER_TRANSFERED_RAW_LOGS = "pod_agent_logs_transmitter_transfered_raw_logs";
    static constexpr const char* COUNTER_TRANSFERED_WRAPPED_LOGS = "pod_agent_logs_transmitter_transfered_wrapped_logs";
    static constexpr const char* COUNTER_NUM_OF_SESSION_ACTIVATION_ERRORS = "pod_agent_logs_transmitter_num_of_session_activation_errors";
    static constexpr const char* COUNTER_NUM_OF_STDOUT_LOG_SESSIONS = "pod_agent_logs_transmitter_num_of_stdout_log_sessions";
    static constexpr const char* COUNTER_NUM_OF_STDERR_LOG_SESSIONS = "pod_agent_logs_transmitter_num_of_stderr_log_sessions";
    static constexpr const char* COUNTER_ERRORS_FROM_PUSH_AGENT = "pod_agent_logs_transmitter_errors_from_push_agent";
    static constexpr const char* COUNTER_LOST_LOGS_ROTATED_BY_PORTO = "pod_agent_logs_transmitter_lost_logs_rotated_by_porto";
    static constexpr const char* COUNTER_NUM_OF_PORTO_LOG_FILES_BECAME_INVALID = "pod_agent_logs_transmitter_num_of_porto_log_files_became_invalid";

private:
    void InitSignals();
    void SendSignal(const TString& signalType, ui64 value);
    void PrintPortoLogFilesBecameInvalidCause(const TVector<TPushClientError>& filesBecameInvalidCause);

private:
    ui64 LastPrintTime_;
    TLogsTransmitterStatisticsPtr Statistics_;
    TSessionHolderPtr StdoutSessionHolder_;
    TSessionHolderPtr StderrSessionHolder_;
    TFileStreamHolderPtr StdoutFileStreamHolder_;
    TFileStreamHolderPtr StderrFileStreamHolder_;
    TLogFramePtr LogFrame_;
    ui32 PrintPeriodSec_;

    static bool IsInitialized_;
    static TRWMutex SignalMutex_;
};

} //namespace NInfra::NPodAgent
