#pragma once

#include <infra/pod_agent/libs/path_util/path_holder.h>
#include <infra/pod_agent/libs/pod_agent/status_repository/workload_status_repository.h>
#include <infra/pod_agent/libs/push_client/utils/push_client_types.h>

#include <util/generic/ptr.h>
#include <util/generic/hash_set.h>

namespace NInfra::NPodAgent {

class TActiveContainersGetter;
using TActiveContainersGetterPtr = TIntrusivePtr<TActiveContainersGetter>;

class TActiveContainersGetter: public TAtomicRefCount<TActiveContainersGetter> {
public:
    TActiveContainersGetter() = default;
    TActiveContainersGetter(
        TWorkloadStatusRepositoryPtr workloadStatusRepository
        , TPathHolderPtr pathHolder
        , TLogFramePtr logFrame
        , const bool isBoxAgentMode
    );
    virtual THashSet<TPushContainer> GetActivePushContainers();
    virtual ~TActiveContainersGetter() = default;

private:
    TString GetLogsFilePath(const TString& workloadId, const ELogType logType);

private:
    static constexpr const char* CONTAINER_PREFIX = "pod_agent_";
    static constexpr const char* BOX_PREFIX = "box_";
    static constexpr const char* WORKLOAD_PREFIX = "workload_";
    static constexpr const char* START_CONTAINER_SUFFIX = "_start";

private:
    TWorkloadStatusRepositoryPtr WorkloadStatusRepository_;
    TPathHolderPtr PathHolder_;
    TLogFramePtr LogFrame_;
    bool IsBoxAgentMode_;
};
} //namespace NInfra::NPodAgent
