#include "active_containers_getter.h"

#include <infra/pod_agent/libs/pod_agent/object_meta/test_lib/test_functions.h>

#include <library/cpp/testing/unittest/registar.h>
#include <util/system/file.h>
#include <util/system/fs.h>

namespace NInfra::NPodAgent::NActiveContainersGetterTest {

static TLogger logger({});

Y_UNIT_TEST_SUITE(ActiveContainersGetterSuite) {

Y_UNIT_TEST(GetActiveContainersWithFullModeTest) {
    TWorkloadStatusRepositoryPtr workloadStatusRepository = new TWorkloadStatusRepository;
    TPushContainer pushContainer1 {{{"pod_agent_box_boxRef0"}, "workload_workload1_start"}, "boxRef0", "workload1"};
    TPushContainer pushContainer2 {{{"pod_agent_box_boxRef0"}, "workload_workload2_start"}, "boxRef0", "workload2"};
    TPushContainer pushContainer3 {{{"pod_agent_box_boxref0"}, "workload_workload3_start"}, "boxRef0", "workload3"};
    workloadStatusRepository->AddObject(NObjectMetaTestLib::CreateWorkloadMetaSimple(pushContainer1.WorkloadId));
    workloadStatusRepository->AddObject(NObjectMetaTestLib::CreateWorkloadMetaSimple(pushContainer2.WorkloadId));
    workloadStatusRepository->AddObject(NObjectMetaTestLib::CreateWorkloadMetaSimple(pushContainer3.WorkloadId));

    TPathHolderPtr pathHolder = new TPathHolder(
        ""
        , {{"", ""}}
        , {{"", ""}}
        , ""
        , ""
        , ""
        , ""
        , ""
        , ""
    );

    TString volumePath = pathHolder->GetVolumePath(TPathHolder::LOGS_VOLUME_ID);
    NFs::MakeDirectory(volumePath);
    TFile stdoutFile1 = TFile(pathHolder->GetWorkloadLogsFilePathAtLogsVolumePath(
        pushContainer1.WorkloadId
        , ToString(ELogType::Stdout))
        , OpenAlways
    );
    TFile stderrFile1 = TFile(pathHolder->GetWorkloadLogsFilePathAtLogsVolumePath(
        pushContainer1.WorkloadId
        , ToString(ELogType::Stderr))
        , OpenAlways
    );
    TFile stdoutFile2 = TFile(pathHolder->GetWorkloadLogsFilePathAtLogsVolumePath(
        pushContainer2.WorkloadId
        , ToString(ELogType::Stdout))
        , OpenAlways
    );
    TFile stderrFile2 = TFile(pathHolder->GetWorkloadLogsFilePathAtLogsVolumePath(
        pushContainer2.WorkloadId
        , ToString(ELogType::Stderr))
        , OpenAlways
    );

    bool isBoxAgentMode = false;

    TActiveContainersGetterPtr activeContainersGetter = new TActiveContainersGetter(workloadStatusRepository, pathHolder, logger.SpawnFrame(), isBoxAgentMode);

    THashSet<TPushContainer> pushContainers = activeContainersGetter->GetActivePushContainers();
    UNIT_ASSERT(pushContainers.contains(pushContainer1));
    UNIT_ASSERT(pushContainers.contains(pushContainer2));
    UNIT_ASSERT(!pushContainers.contains(pushContainer3));

    NFs::RemoveRecursive(volumePath);
}

Y_UNIT_TEST(GetActiveContainersWithBoxModeTest) {
    TWorkloadStatusRepositoryPtr workloadStatusRepository = new TWorkloadStatusRepository;
    TPushContainer pushContainer1 {{"pod_agent_workload_workload1_start"}, "", "workload1"};
    TPushContainer pushContainer2 {{"pod_agent_workload_workload2_start"}, "", "workload2"};
    TPushContainer pushContainer3 {{"pod_agent_workload_workload3_start"}, "", "workload3"};
    workloadStatusRepository->AddObject(NObjectMetaTestLib::CreateWorkloadMetaWithoutBox(pushContainer1.WorkloadId));
    workloadStatusRepository->AddObject(NObjectMetaTestLib::CreateWorkloadMetaWithoutBox(pushContainer2.WorkloadId));
    workloadStatusRepository->AddObject(NObjectMetaTestLib::CreateWorkloadMetaWithoutBox(pushContainer3.WorkloadId));

    bool isBoxAgentMode = true;

    TString portoLogsDir = NFs::CurrentWorkingDirectory() + "/porto_logs";
    TPathHolderPtr pathHolder = new TPathHolder(
        ""
        , {{"", ""}}
        , {{"", ""}}
        , ""
        , ""
        , ""
        , ""
        , portoLogsDir
        , ""
        , isBoxAgentMode
    );

    NFs::MakeDirectory(portoLogsDir);
    TFile stdoutFile1 = TFile(pathHolder->GetWorkloadLogsFilePathInBox(
        pushContainer1.WorkloadId
        , ToString(ELogType::Stdout))
        , OpenAlways
    );
    TFile stderrFile1 = TFile(pathHolder->GetWorkloadLogsFilePathInBox(
        pushContainer1.WorkloadId
        , ToString(ELogType::Stderr))
        , OpenAlways
    );
    TFile stdoutFile2 = TFile(pathHolder->GetWorkloadLogsFilePathInBox(
        pushContainer2.WorkloadId
        , ToString(ELogType::Stdout))
        , OpenAlways
    );
    TFile stderrFile2 = TFile(pathHolder->GetWorkloadLogsFilePathInBox(
        pushContainer2.WorkloadId
        , ToString(ELogType::Stderr))
        , OpenAlways
    );

    TActiveContainersGetterPtr activeContainersGetter = new TActiveContainersGetter(workloadStatusRepository, pathHolder, logger.SpawnFrame(), isBoxAgentMode);

    THashSet<TPushContainer> pushContainers = activeContainersGetter->GetActivePushContainers();
    UNIT_ASSERT(pushContainers.contains(pushContainer1));
    UNIT_ASSERT(pushContainers.contains(pushContainer2));
    UNIT_ASSERT(!pushContainers.contains(pushContainer3));

    NFs::RemoveRecursive(portoLogsDir);
}

}

} //namespace NInfra::NPodAgent::NActiveContainerGetterTest
