#include "containers_set_builder.h"

namespace NInfra::NPodAgent {

TContainersSetBuilderPtr TContainersSetBuilder::Init(const THashSet<TPushContainer>& pushContainers) {
    return TContainersSetBuilderPtr(new TContainersSetBuilder())
           ->Union(pushContainers);
}

TContainersSetBuilderPtr TContainersSetBuilder::Union(const THashSet<TPushContainer>& pushContainers) {
    PushContainers_.insert(pushContainers.begin(), pushContainers.end());
    return this;
}

TContainersSetBuilderPtr TContainersSetBuilder::Minus(const THashSet<TPushContainer>& pushContainers) {
    for (auto it = PushContainers_.begin(); it != PushContainers_.end();) {
        auto itToErase = it++;
        if (pushContainers.contains(*itToErase)) {
            PushContainers_.erase(itToErase);
        }
    }

    return this;
}

TContainersSetBuilderPtr TContainersSetBuilder::Filter(TFilterPtr filter) {
    PushContainers_ = filter->Filter(std::move(PushContainers_));
    return this;
}

THashSet<TPushContainer> TContainersSetBuilder::Result() {
    return PushContainers_;
}

} //namespace NInfra::NPodAgent
