#pragma once

#include <infra/pod_agent/libs/pod_agent/logs_transmitter/filter/filter.h>
#include <infra/pod_agent/libs/push_client/utils/push_client_types.h>
#include <util/generic/ptr.h>

namespace NInfra::NPodAgent {

class TContainersSetBuilder;
using TContainersSetBuilderPtr = TIntrusivePtr<TContainersSetBuilder>;

class TContainersSetBuilder: public TAtomicRefCount<TContainersSetBuilder> {
public:
    static TContainersSetBuilderPtr Init(const THashSet<TPushContainer>& pushContainers);
    TContainersSetBuilderPtr Union(const THashSet<TPushContainer>& pushContainers);
    TContainersSetBuilderPtr Minus(const THashSet<TPushContainer>& pushContainers);
    TContainersSetBuilderPtr Filter(TFilterPtr filter);
    THashSet<TPushContainer> Result();

private:
    THashSet<TPushContainer> PushContainers_;
};

} //namespace NInfra::NPodAgent
