#include "containers_set_builder.h"
#include "infra/pod_agent/libs/pod_agent/logs_transmitter/filter/filter_mock.h"

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NContainersSetBuilderTest {

static const TPushContainer container1 = {{{"box1"}, "workload1"}, "box1", "workload1"};
static const TPushContainer container2 = {{{"box2"}, "workload2"}, "box2", "workload2"};
static const TPushContainer container3 = {{{"box3"}, "workload3"}, "box3", "workload3"};
static const TPushContainer container4 = {{{"box4"}, "workload4"}, "box4", "workload4"};

Y_UNIT_TEST_SUITE(ContainersSetBuilderSuite) {

    Y_UNIT_TEST(InitTest) {
        THashSet<TPushContainer> pushContainers = {
            container1
            , container2
        };

        UNIT_ASSERT_EQUAL(pushContainers, TContainersSetBuilder::Init(pushContainers)->Result());
    }

    Y_UNIT_TEST(UnionTest) {
        THashSet<TPushContainer> pushContainers1 = {
            container1
            , container2
        };

        THashSet<TPushContainer> pushContainers2 = {
            container2
            , container3
        };

        THashSet<TPushContainer> result = {
            container1
            , container2
            , container3
        };

        UNIT_ASSERT_EQUAL(result, TContainersSetBuilder::Init(pushContainers1)->Union(pushContainers2)->Result());
    }

    Y_UNIT_TEST(DeductionTest) {
        THashSet<TPushContainer> pushContainers1 = {
            container1
            , container2
        };

        THashSet<TPushContainer> pushContainers2 = {
            container2
            , container3
        };

        THashSet<TPushContainer> result = {
            container1
        };

        UNIT_ASSERT_EQUAL(result, TContainersSetBuilder::Init(pushContainers1)->Minus(pushContainers2)->Result());
    }

    Y_UNIT_TEST(FilterTest) {
        struct TTestFilter: public TMockFilter {
            THashSet<TPushContainer> Filter(THashSet<TPushContainer>&& pushContainers) override {
                pushContainers.erase(container1);
                return pushContainers;
            }
        };

        THashSet<TPushContainer> pushContainers1 = {
            container1
            , container2
            , container3
        };

        THashSet<TPushContainer> result = {
            container2
            , container3
        };

        UNIT_ASSERT_EQUAL(result, TContainersSetBuilder::Init(pushContainers1)->Filter(new TTestFilter)->Result());
    }

    Y_UNIT_TEST(MultipleTest) {
        struct TTestFilter: public TMockFilter {
            THashSet<TPushContainer> Filter(THashSet<TPushContainer>&& pushContainers) override {
                pushContainers.erase(container4);
                return pushContainers;
            }
        };

        THashSet<TPushContainer> initContainers = {
            container1
            , container2
        };

        THashSet<TPushContainer> differenceContainers = {
            container2
            , container3
        };

        THashSet<TPushContainer> unionPushContainers = {
            container3
            , container4
        };

        THashSet<TPushContainer> result = {
            container1
            , container3
        };

        UNIT_ASSERT_EQUAL(result, TContainersSetBuilder::
        Init(initContainers)
            ->Minus(differenceContainers)
            ->Union(unionPushContainers)
            ->Filter(new TTestFilter)
            ->Result()
        );
    }
}

} //namespace NInfra::NPodAgent::NContainersSetBuilderTest
