#pragma once

#include <infra/libs/outcome/result.h>
#include <infra/pod_agent/libs/push_client/utils/push_client_types.h>
#include <util/system/file.h>

namespace NInfra::NPodAgent {

class TFileSystemUtils;

using TFileSystemUtilsPtr = TIntrusivePtr<TFileSystemUtils>;

class TFileSystemUtils: public TAtomicRefCount<TFileSystemUtils> {
public:
    TFileSystemUtils() = default;
    virtual TExpected<blksize_t, TPushClientError> GetFileSystemBlockSize();
    virtual bool Exists(const TString& path) const;
    virtual TExpected<void, TPushClientError> CutHeadOfFile(const TFile& file, off64_t len) const;
    virtual TExpected<void, TPushClientError> MakeDirectory(const TString& path) const;
    virtual TExpected<ino_t, TPushClientError> GetFileInode(const TString& path) const;
    virtual ~TFileSystemUtils() = default;

private:
    static constexpr const char* ROOT_PATH = "/";
    static const i32 ZERO_OFFSET = 0;
};

} //namespace NInfra::NPodAgent
