#pragma once

#include "file_system_utils.h"

namespace NInfra::NPodAgent {

class TMockFileSystemUtils: public TFileSystemUtils {
public:
    TExpected<blksize_t, TPushClientError> GetFileSystemBlockSize() override { return TExpected<blksize_t, TPushClientError>::DefaultSuccess(); }
    virtual bool Exists(const TString&) const override { return true; }
    virtual TExpected<void, TPushClientError> CutHeadOfFile(const TFile&, off64_t) const override { return TExpected<void, TPushClientError>::DefaultSuccess(); }
    virtual TExpected<void, TPushClientError> MakeDirectory(const TString&) const override { return TExpected<void, TPushClientError>::DefaultSuccess(); }
    virtual TExpected<ino_t, TPushClientError> GetFileInode(const TString&) const override { return TExpected<ino_t, TPushClientError>::DefaultSuccess(); }
};

} //namespace NInfra::NPodAgent
