#include "logs_transmitter_utils.h"
#include "file_system_utils.h"

#include <errno.h>

#include <infra/pod_agent/libs/multi_unistat/multi_unistat.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/holders/offset_holder.h>
#include <library/cpp/logger/all.h>
#include <util/system/fs.h>

namespace NInfra::NPodAgent::NLogsTransmitterUtils {

static const char WORKLOAD_SEPARATOR = '_';
static const constexpr char* METADATA_SUFFIX = "meta";
static const constexpr char* METADATA_FILE_EXTENSION = ".json";
static const constexpr char* DIR_SEPARATOR = "/";

NLogEvent::TLogsTransmitterJobException ConstructExceptionEvent(const std::variant<TPortoError, TPushClientError>& error) {
    if (std::holds_alternative<TPortoError>(error)) {
        NLogEvent::TLogsTransmitterJobException ev;
        ev.SetMessage(ToString(std::get<TPortoError>(error)));
        return ev;
    }

    if (std::holds_alternative<TPushClientError>(error)) {
        NLogEvent::TLogsTransmitterJobException ev;
        ev.SetMessage(TStringBuilder()
            << "PushClientError:"
            << ToString(std::get<TPushClientError>(error).Errno)
            << ':' << std::get<TPushClientError>(error).Message
        );
        return ev;
    }

    ythrow yexception() << "Unable to construct exception event";
}

TString GetMetadataFilePath(TPathHolderPtr pathHolder, const TPushContainer& pushContainer, const ELogType& logType) {
    return TStringBuilder()
        << pathHolder->GetWorkloadLogsMetaPathAtLogsVolumePath()
        << DIR_SEPARATOR
        << pushContainer.WorkloadId
        << WORKLOAD_SEPARATOR
        << logType
        << WORKLOAD_SEPARATOR
        << METADATA_SUFFIX
        << METADATA_FILE_EXTENSION;
}

} //namespace NInfra::NPodAgent::NLogsTransmitterUtils

