#pragma once

#include "file_system_utils.h"

#include <infra/libs/logger/log_frame.h>
#include <infra/pod_agent/libs/path_util/path_holder.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/holders/updatable_holder.h>
#include <infra/pod_agent/libs/porto_client/client.h>
#include <infra/pod_agent/libs/porto_client/porto_types.h>
#include <infra/pod_agent/libs/push_client/utils/push_client_types.h>

#include <util/generic/variant.h>

namespace NInfra::NPodAgent::NLogsTransmitterUtils {

NLogEvent::TLogsTransmitterJobException ConstructExceptionEvent(const std::variant<TPortoError, TPushClientError>& error);

TString GetMetadataDirectory(TPathHolderPtr pathHolder, const TPushContainer& pushContainer);

TString GetMetadataFilePath(TPathHolderPtr pathHolder, const TPushContainer& pushContainer, const ELogType& logType);

} //namespace NInfra::NPodAgent::NLogsTransmitterUtils
