#include "need_transmit_logs_detector.h"

namespace NInfra::NPodAgent {

TNeedTransmitLogsDetector::TNeedTransmitLogsDetector(TStatusRepositoryPtr statusRepository)
    : StatusRepository_(statusRepository)
{}

bool TNeedTransmitLogsDetector::NeedTransmitLogs() const {
    if (IsPodAgentTargetStateActive())
        return true;

    TWorkloadStatusRepositoryPtr workloadStatusRepository = StatusRepository_->GetWorkloadStatusRepository();
    if (workloadStatusRepository->HasObject(UNIFIED_AGENT_WORKLOAD_ID)) {
        API::EWorkloadState unifiedAgentState = workloadStatusRepository->GetObjectStatus(UNIFIED_AGENT_WORKLOAD_ID).state();
        if ((API::EWorkloadState_ACTIVE == unifiedAgentState) || (API::EWorkloadState_DEACTIVATING == unifiedAgentState) || (API::EWorkloadState_REMOVING == unifiedAgentState))
            return true;
    }

    return false;
}

bool TNeedTransmitLogsDetector::IsPodAgentTargetStateActive() const {
   API::EPodAgentTargetState podAgentTargetState = StatusRepository_->GetTargetState();
   //We interpret API::EPodAgentTargetState_UNKNOWN as ACTIVE
   if ((API::EPodAgentTargetState_ACTIVE == podAgentTargetState) || (API::EPodAgentTargetState_UNKNOWN == podAgentTargetState))
       return true;
   return false;
}

} //namespace NInfra::NPodAgent
