#pragma once

#include <infra/pod_agent/libs/pod_agent/status_repository/status_repository.h>

namespace NInfra::NPodAgent {

class TNeedTransmitLogsDetector;
using TNeedTransmitLogsDetectorPtr = TIntrusivePtr<TNeedTransmitLogsDetector>;

class TNeedTransmitLogsDetector: public TAtomicRefCount<TNeedTransmitLogsDetector> {
public:
    TNeedTransmitLogsDetector() = default;
    TNeedTransmitLogsDetector(TStatusRepositoryPtr statusRepository);
    
    //returns false when pod agent target state not active and unified agent is not alive(state is not active or not deactivating or not removing), otherwise returns true
    virtual bool NeedTransmitLogs() const;
    virtual ~TNeedTransmitLogsDetector() = default;

private:
    bool IsPodAgentTargetStateActive() const;

//public for tests
public:
    static constexpr const char* UNIFIED_AGENT_WORKLOAD_ID = "logbroker_push_agent_workload";

private:
    TStatusRepositoryPtr StatusRepository_;
};
} //namespace NInfra::NPodAgent
