#include "need_transmit_logs_detector.h"

#include <infra/pod_agent/libs/pod_agent/object_meta/test_lib/test_functions.h>

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NNeedTransmitLogsDetectorTest {

static TLogger logger({});

Y_UNIT_TEST_SUITE(ActiveContainersGetterSuite) {

    static TStatusRepositoryPtr CreateStatusRepository() {
        return new TStatusRepository(
            new TUpdateHolder()
            , new TBoxStatusRepository()
            , new TLayerStatusRepository()
            , new TStaticResourceStatusRepository()
            , new TVolumeStatusRepository()
            , new TWorkloadStatusRepository()
        );
    }

    static TNeedTransmitLogsDetectorPtr CreateNeedTransmitLogsDetectorWithoutUnifiedAgentWorkload(const API::EPodAgentTargetState podAgentTargetState) {
        TStatusRepositoryPtr statusRepository = CreateStatusRepository();
        
        statusRepository->SetTargetState(podAgentTargetState);
        return new TNeedTransmitLogsDetector(statusRepository);
    }

    static TNeedTransmitLogsDetectorPtr CreateNeedTransmitLogsDetectorWithUnifiedAgentWorkload(const API::EPodAgentTargetState podAgentTargetState, API::EWorkloadState unifiedAgentState) {
        TStatusRepositoryPtr statusRepository = CreateStatusRepository();

        TWorkloadStatusRepositoryPtr workloadStatusRepository = statusRepository->GetWorkloadStatusRepository();
        workloadStatusRepository->AddObject(NObjectMetaTestLib::CreateWorkloadMetaSimple(TNeedTransmitLogsDetector::UNIFIED_AGENT_WORKLOAD_ID));
        workloadStatusRepository->UpdateObjectState(TNeedTransmitLogsDetector::UNIFIED_AGENT_WORKLOAD_ID, unifiedAgentState);
        statusRepository->SetTargetState(podAgentTargetState);
        return new TNeedTransmitLogsDetector(statusRepository);
    }

    Y_UNIT_TEST(NeedTransmitLogsDetectorWithoutUnifiedAgentWorkloadTest) {
        UNIT_ASSERT_EQUAL(CreateNeedTransmitLogsDetectorWithoutUnifiedAgentWorkload(API::EPodAgentTargetState_UNKNOWN)->NeedTransmitLogs(), true);
        UNIT_ASSERT_EQUAL(CreateNeedTransmitLogsDetectorWithoutUnifiedAgentWorkload(API::EPodAgentTargetState_ACTIVE)->NeedTransmitLogs(), true);
        UNIT_ASSERT_EQUAL(CreateNeedTransmitLogsDetectorWithoutUnifiedAgentWorkload(API::EPodAgentTargetState_REMOVED)->NeedTransmitLogs(), false);
        UNIT_ASSERT_EQUAL(CreateNeedTransmitLogsDetectorWithoutUnifiedAgentWorkload(API::EPodAgentTargetState_SUSPENDED)->NeedTransmitLogs(), false);
    }

    Y_UNIT_TEST(NeedTransmitLogsDetectorWithUnifiedAgentWorkloadTest) {
        UNIT_ASSERT_EQUAL(CreateNeedTransmitLogsDetectorWithUnifiedAgentWorkload(API::EPodAgentTargetState_UNKNOWN, API::EWorkloadState_ACTIVE)->NeedTransmitLogs(), true);
        UNIT_ASSERT_EQUAL(CreateNeedTransmitLogsDetectorWithUnifiedAgentWorkload(API::EPodAgentTargetState_UNKNOWN, API::EWorkloadState_DEACTIVATING)->NeedTransmitLogs(), true);
        UNIT_ASSERT_EQUAL(CreateNeedTransmitLogsDetectorWithUnifiedAgentWorkload(API::EPodAgentTargetState_UNKNOWN, API::EWorkloadState_REMOVING)->NeedTransmitLogs(), true);

        UNIT_ASSERT_EQUAL(CreateNeedTransmitLogsDetectorWithUnifiedAgentWorkload(API::EPodAgentTargetState_ACTIVE, API::EWorkloadState_ACTIVE)->NeedTransmitLogs(), true);
        UNIT_ASSERT_EQUAL(CreateNeedTransmitLogsDetectorWithUnifiedAgentWorkload(API::EPodAgentTargetState_ACTIVE, API::EWorkloadState_DEACTIVATING)->NeedTransmitLogs(), true);
        UNIT_ASSERT_EQUAL(CreateNeedTransmitLogsDetectorWithUnifiedAgentWorkload(API::EPodAgentTargetState_ACTIVE, API::EWorkloadState_REMOVING)->NeedTransmitLogs(), true);

        UNIT_ASSERT_EQUAL(CreateNeedTransmitLogsDetectorWithUnifiedAgentWorkload(API::EPodAgentTargetState_REMOVED, API::EWorkloadState_ACTIVE)->NeedTransmitLogs(), true);
        UNIT_ASSERT_EQUAL(CreateNeedTransmitLogsDetectorWithUnifiedAgentWorkload(API::EPodAgentTargetState_REMOVED, API::EWorkloadState_DEACTIVATING)->NeedTransmitLogs(), true);
        UNIT_ASSERT_EQUAL(CreateNeedTransmitLogsDetectorWithUnifiedAgentWorkload(API::EPodAgentTargetState_REMOVED, API::EWorkloadState_REMOVING)->NeedTransmitLogs(), true);
        UNIT_ASSERT_EQUAL(CreateNeedTransmitLogsDetectorWithUnifiedAgentWorkload(API::EPodAgentTargetState_REMOVED, API::EWorkloadState_DEAD)->NeedTransmitLogs(), false);

        UNIT_ASSERT_EQUAL(CreateNeedTransmitLogsDetectorWithUnifiedAgentWorkload(API::EPodAgentTargetState_SUSPENDED, API::EWorkloadState_ACTIVE)->NeedTransmitLogs(), true);
        UNIT_ASSERT_EQUAL(CreateNeedTransmitLogsDetectorWithUnifiedAgentWorkload(API::EPodAgentTargetState_SUSPENDED, API::EWorkloadState_DEACTIVATING)->NeedTransmitLogs(), true);
        UNIT_ASSERT_EQUAL(CreateNeedTransmitLogsDetectorWithUnifiedAgentWorkload(API::EPodAgentTargetState_SUSPENDED, API::EWorkloadState_REMOVING)->NeedTransmitLogs(), true);
        UNIT_ASSERT_EQUAL(CreateNeedTransmitLogsDetectorWithUnifiedAgentWorkload(API::EPodAgentTargetState_SUSPENDED, API::EWorkloadState_DEAD)->NeedTransmitLogs(), false);
    }
}

} //namespace NInfra::NPodAgent::NActiveContainerGetterTest
