#include "rotation_params_validator.h"

namespace NInfra::NPodAgent::NRotationParamsValidator {

static constexpr const double MIN_PERMITTED_PORTION_TO_CUT = 0.0;
static constexpr const double MAX_PERMITTED_PORTION_TO_CUT = 1.0;

TExpected<i32, TPushClientError> AreRotationParamsValid(ui32 maxLogsFileSize, double minPortionToCut, blksize_t blockSize) {
    if (minPortionToCut < MIN_PERMITTED_PORTION_TO_CUT || minPortionToCut >= MAX_PERMITTED_PORTION_TO_CUT) {
        return TPushClientError{EPushClientError::InvalidRotateParams, TStringBuilder() << "Invalid rotate params: minPortionToCut = " << minPortionToCut << ". minPortionToCut must be in interval [" << MIN_PERMITTED_PORTION_TO_CUT << ";" << MAX_PERMITTED_PORTION_TO_CUT << ")."};
    }

    if (blockSize > maxLogsFileSize) {
        return TPushClientError{EPushClientError::InvalidRotateParams, TStringBuilder() << "Invalid rotate params: blockSize = " << blockSize << " more than maxLogsFileSize = " << maxLogsFileSize};
    }

    ui32 lengthToCut = maxLogsFileSize * minPortionToCut;

    if (lengthToCut % blockSize != 0) {
        lengthToCut -= lengthToCut % blockSize;
        lengthToCut += blockSize;
    }

    return lengthToCut <= maxLogsFileSize;
}

} //namespace NInfra::NPodAgent::NRotationParamsValidator
