#include "rotation_params_validator.h"

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NRotationParamsValidatorTest {

Y_UNIT_TEST_SUITE(RotationParamsValidatorSuite) {

    Y_UNIT_TEST(SimpleTest) {
        UNIT_ASSERT(NRotationParamsValidator::AreRotationParamsValid(10000, 0.2, 4096).Success());
        UNIT_ASSERT(NRotationParamsValidator::AreRotationParamsValid(10000, 0.5, 4096).Success());
        UNIT_ASSERT(NRotationParamsValidator::AreRotationParamsValid(10000, 0.7, 4096).Success());
        UNIT_ASSERT(!NRotationParamsValidator::AreRotationParamsValid(7000, 0.8, 4096).Success());
    }

    Y_UNIT_TEST(PortionLessThanZeroOrMoreThanOneTest) {
        auto validResult1 = NRotationParamsValidator::AreRotationParamsValid(10000, 1.2, 4096);
        UNIT_ASSERT(!validResult1);
        UNIT_ASSERT_EQUAL(EPushClientError::InvalidRotateParams, validResult1.Error().Errno);
        UNIT_ASSERT_STRING_CONTAINS(validResult1.Error().Message, "Invalid rotate params: minPortionToCut = 1.2");

        auto validResult2 = NRotationParamsValidator::AreRotationParamsValid(10000, -0.5, 4096);
        UNIT_ASSERT(!validResult1);
        UNIT_ASSERT_EQUAL(EPushClientError::InvalidRotateParams, validResult2.Error().Errno);
        UNIT_ASSERT_STRING_CONTAINS(validResult2.Error().Message, "Invalid rotate params: minPortionToCut = -0.5");
    }

    Y_UNIT_TEST(BlockSizeMoreThanMaxFileSizeTest) {
        auto validResult1 = NRotationParamsValidator::AreRotationParamsValid(10000, 0.5, 15000);
        UNIT_ASSERT(!validResult1);
        UNIT_ASSERT_EQUAL(EPushClientError::InvalidRotateParams, validResult1.Error().Errno);
        UNIT_ASSERT_STRING_CONTAINS("Invalid rotate params: blockSize = 15000 more than maxLogsFileSize = 10000", validResult1.Error().Message);
    }
}

}
