#pragma once

#include <infra/libs/logger/logger.h>

#include <util/datetime/base.h>
#include <util/generic/ptr.h>
#include <util/generic/string.h>

namespace NInfra::NPodAgent {

class IPeriodJob;
using TPeriodJobPtr = TIntrusivePtr<IPeriodJob>;

// All logs must be in Run() function
// Run() function mustn't throw exceptions

class IPeriodJob: public TAtomicRefCount<IPeriodJob> {
public:
    IPeriodJob(
        const TString& name
        , const TDuration period
        , TLogFramePtr periodWorkerEventsLogFrame
    )
        : Name_(name)
        , Period_(period)
        , PeriodWorkerEventsLogFrame_(periodWorkerEventsLogFrame)
    {}

    virtual ~IPeriodJob() = default;

    virtual void Run() = 0;
    virtual void Shutdown();

    TString GetName() const;
    TDuration GetPeriod() const;
    TLogFramePtr GetPeriodWorkerEventsLogFrame() const;

private:
    const TString Name_;
    const TDuration Period_;
    TLogFramePtr PeriodWorkerEventsLogFrame_;
};

} // namespace NInfra::NPodAgent
