#include "period_job.h"

#include <util/generic/cast.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

namespace NInfra::NPodAgent::NPeriodJobTest  {

class TTestPeriodJob;
using TTestPeriodJobPtr = TIntrusivePtr<TTestPeriodJob>;

static TLogger logger({});

class TTestPeriodJob : public IPeriodJob {
public:
    TTestPeriodJob(
        const TString& name
        , const TDuration& period
    )
        : IPeriodJob(name, period, logger.SpawnFrame())
    {}

    void Run() final {
        // Do nothing
    }
};

Y_UNIT_TEST_SUITE(PeriodJobSuite) {

Y_UNIT_TEST(TestGetter) {
    TTestPeriodJobPtr job = new TTestPeriodJob("name", TDuration::Minutes(10));

    UNIT_ASSERT_EQUAL_C("name", job->GetName(), job->GetName());
    UNIT_ASSERT_EQUAL_C(TDuration::Minutes(10), job->GetPeriod(), ToString(job->GetPeriod()));
}

}

} // namespace NInfra::NPodAgent::NPeriodJobWorkerTest
