#pragma once

#include "period_job.h"

#include <infra/libs/logger/logger.h>

#include <util/datetime/base.h>
#include <util/generic/vector.h>
#include <util/system/condvar.h>
#include <util/system/thread.h>

namespace NInfra::NPodAgent {

/*
    Runs jobs in every 'Period_'
    If job need "stop the world" job must do it in job Run function

    Method Wait() waits for signal from Shutdown() and waits for current job to end
    Method Stop() calls {Shutdown(); Wait();}

    Method AddJob() add new job only if TPeriodJobWorker stopped otherwise it throws exception
*/
class TPeriodJobWorker {
public:
    TPeriodJobWorker(
        const TDuration& mainLoopPeriod
        , TLogFramePtr logFrame
    )
        : NeedQuit_(true)
        , RunnerThread_(RunMainLoop, this)
        , LogFrame_(logFrame)
        , MainLoopPeriod_(mainLoopPeriod)
    {}

    ~TPeriodJobWorker() {
        try {
            Stop();
        } catch (...) {
        }
    }

    void Start();

    void Stop() {
        Shutdown();
        Wait();
    }

    void Shutdown();

    void Wait();

    void AddJob(TPeriodJobPtr job);

private:
    static void* RunMainLoop(void* me);
    static void* RunJobLoop(void* data);

    void InitSignals();

    void PushSignal(const TString& name, double value);
    void SetJobDurationSignal(const TString& jobName, const TDuration& duration);

private:
    TAtomic NeedQuit_;
    TCondVar QuitSignal_;
    TMutex Mutex_;
    TThread RunnerThread_;

    TVector<TPeriodJobPtr> Jobs_;

    TLogFramePtr LogFrame_;
    const TDuration MainLoopPeriod_;

    static inline const TString SIGNAL_PREFIX = "pod_agent_period_job_worker_";
    static inline const TString SIGNAL_JOB_TIME_SUFFIX = "_time_ms";
};

} // namespace NInfra::NPodAgent
