#include "graph.h"

namespace NInfra::NPodAgent {

void TGraph::RemoveOutEdges(const TNode& node) {
    for (const TNode& to : OutEdges_[node]) {
        InEdges_[to].erase(node);
        if (InEdges_[to].empty()) {
            InEdges_.erase(to);
        }
    }

    OutEdges_.erase(node);
}

void TGraph::AddEdge(const TNode& from, const TNode& to) {
    OutEdges_[from].insert(to);
    InEdges_[to].insert(from);
}

void TGraph::RemoveEdge(const TNode& from, const TNode& to) {
    OutEdges_[from].erase(to);
    if (OutEdges_[from].empty()) {
        OutEdges_.erase(from);
    }

    InEdges_[to].erase(from);
    if (InEdges_[to].empty()) {
        InEdges_.erase(to);
    }
}

const TSet<TGraph::TNode>& TGraph::GetInEdges(const TNode& node) const {
    static TSet<TNode> emptySet;

    auto ptr = InEdges_.FindPtr(node);

    if (ptr) {
        return *ptr;
    } else {
        return emptySet;
    }
}

const TSet<TGraph::TNode>& TGraph::GetOutEdges(const TNode& node) const {
    static TSet<TNode> emptySet;

    auto ptr = OutEdges_.FindPtr(node);

    if (ptr) {
        return *ptr;
    } else {
        return emptySet;
    }
}

const TMap<TGraph::TNode, TSet<TGraph::TNode>>& TGraph::GetAllInEdges() const {
    return InEdges_;
}

const TMap<TGraph::TNode, TSet<TGraph::TNode>>& TGraph::GetAllOutEdges() const {
    return OutEdges_;
}

} // namespace NInfra::NPodAgent
