#pragma once

#include <util/generic/map.h>
#include <util/generic/set.h>
#include <util/string/builder.h>

namespace NInfra::NPodAgent {

class TGraph {
public:
    enum ENodeType {
        STATIC_RESOURCE   /* "static_resource" */,
        LAYER             /* "layer" */,
        VOLUME            /* "volume" */,
        BOX               /* "box" */,
        WORKLOAD          /* "workload" */
    };

    struct TNode {
        TNode(const TString& id, ENodeType type)
            : Id_(id)
            , Type_(type)
        {}

        bool operator<(const TNode& other) const {
            return Id_ < other.Id_ || (Id_ == other.Id_ && Type_ < other.Type_);
        }

        bool operator==(const TNode& other) const {
            return Id_ == other.Id_ && Type_ == other.Type_;
        }

        bool operator!=(const TNode& other) const {
            return Id_ != other.Id_ || Type_ != other.Type_;
        }

        TString ToString() const {
            return TStringBuilder()
                << Type_
                << " "
                << Id_;
        }

        TString Id_;
        ENodeType Type_;
    };

public:
    void RemoveOutEdges(const TNode& node);
    void AddEdge(const TNode& from, const TNode& to);
    void RemoveEdge(const TNode& from, const TNode& to);
    const TSet<TNode>& GetInEdges(const TNode& node) const;
    const TSet<TNode>& GetOutEdges(const TNode& node) const;
    const TMap<TNode, TSet<TNode>>& GetAllInEdges() const;
    const TMap<TNode, TSet<TNode>>& GetAllOutEdges() const;

protected:
    TMap<TNode, TSet<TNode>> InEdges_;
    TMap<TNode, TSet<TNode>> OutEdges_;
};

} // namespace NInfra::NPodAgent
