#include "graph.h"

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

namespace NInfra::NPodAgent::NGraphTest {

Y_UNIT_TEST_SUITE(TGraphTestSuite) {

Y_UNIT_TEST(TestNodeOperators) {
    TGraph::TNode node1("id1", TGraph::ENodeType::WORKLOAD);
    TGraph::TNode node2("id1", TGraph::ENodeType::BOX);

    TGraph::TNode node3("id2", TGraph::ENodeType::BOX);

    UNIT_ASSERT(node2 < node1);
    UNIT_ASSERT(node2 < node3);
    UNIT_ASSERT(node1 != node2);
    UNIT_ASSERT(node1 != node3);
    UNIT_ASSERT(node2 != node3);
    UNIT_ASSERT(!(node1 != node1));
    UNIT_ASSERT(node1 == node1);
    UNIT_ASSERT(node2 == node2);
    UNIT_ASSERT(node3 == node3);
    UNIT_ASSERT(!(node1 == node2));
}

Y_UNIT_TEST(TestGraphAddEdge) {
    TGraph graph;

    const TSet<TGraph::TNode> v1Out = {TGraph::TNode("v2", TGraph::ENodeType::BOX), TGraph::TNode("v3", TGraph::ENodeType::BOX)};
    const TSet<TGraph::TNode> v1In = {};
    const TSet<TGraph::TNode> v2Out = {TGraph::TNode("v5", TGraph::ENodeType::VOLUME)};
    const TSet<TGraph::TNode> v2In = {TGraph::TNode("v1", TGraph::ENodeType::WORKLOAD), TGraph::TNode("v4", TGraph::ENodeType::WORKLOAD)};
    const TSet<TGraph::TNode> v3Out = {};
    const TSet<TGraph::TNode> v3In = {TGraph::TNode("v1", TGraph::ENodeType::WORKLOAD)};
    const TSet<TGraph::TNode> v4Out = {TGraph::TNode("v2", TGraph::ENodeType::BOX)};
    const TSet<TGraph::TNode> v4In = {};
    const TSet<TGraph::TNode> v5Out = {};
    const TSet<TGraph::TNode> v5In = {TGraph::TNode("v2", TGraph::ENodeType::BOX)};

    const TMap<TGraph::TNode, TSet<TGraph::TNode>> allOut = {
        {TGraph::TNode("v1", TGraph::ENodeType::WORKLOAD), v1Out}
        , {TGraph::TNode("v2", TGraph::ENodeType::BOX), v2Out}
        , {TGraph::TNode("v4", TGraph::ENodeType::WORKLOAD), v4Out}
    };

    const TMap<TGraph::TNode, TSet<TGraph::TNode>> allIn = {
        {TGraph::TNode("v2", TGraph::ENodeType::BOX), v2In}
        , {TGraph::TNode("v3", TGraph::ENodeType::BOX), v3In}
        , {TGraph::TNode("v5", TGraph::ENodeType::VOLUME), v5In}
    };

    graph.AddEdge(TGraph::TNode("v1", TGraph::ENodeType::WORKLOAD), TGraph::TNode("v2", TGraph::ENodeType::BOX));
    graph.AddEdge(TGraph::TNode("v1", TGraph::ENodeType::WORKLOAD), TGraph::TNode("v3", TGraph::ENodeType::BOX));
    graph.AddEdge(TGraph::TNode("v4", TGraph::ENodeType::WORKLOAD), TGraph::TNode("v2", TGraph::ENodeType::BOX));
    graph.AddEdge(TGraph::TNode("v2", TGraph::ENodeType::BOX), TGraph::TNode("v5", TGraph::ENodeType::VOLUME));

    UNIT_ASSERT(graph.GetInEdges(TGraph::TNode("none", TGraph::ENodeType::LAYER)).empty());
    UNIT_ASSERT(graph.GetOutEdges(TGraph::TNode("none", TGraph::ENodeType::LAYER)).empty());

    UNIT_ASSERT_EQUAL(graph.GetOutEdges(TGraph::TNode("v1", TGraph::ENodeType::WORKLOAD)), v1Out);
    UNIT_ASSERT_EQUAL(graph.GetInEdges(TGraph::TNode("v1", TGraph::ENodeType::WORKLOAD)), v1In);
    UNIT_ASSERT_EQUAL(graph.GetOutEdges(TGraph::TNode("v2", TGraph::ENodeType::BOX)), v2Out);
    UNIT_ASSERT_EQUAL(graph.GetInEdges(TGraph::TNode("v2", TGraph::ENodeType::BOX)), v2In);
    UNIT_ASSERT_EQUAL(graph.GetOutEdges(TGraph::TNode("v3", TGraph::ENodeType::BOX)), v3Out);
    UNIT_ASSERT_EQUAL(graph.GetInEdges(TGraph::TNode("v3", TGraph::ENodeType::BOX)), v3In);
    UNIT_ASSERT_EQUAL(graph.GetOutEdges(TGraph::TNode("v4", TGraph::ENodeType::WORKLOAD)), v4Out);
    UNIT_ASSERT_EQUAL(graph.GetInEdges(TGraph::TNode("v4", TGraph::ENodeType::WORKLOAD)), v4In);
    UNIT_ASSERT_EQUAL(graph.GetOutEdges(TGraph::TNode("v5", TGraph::ENodeType::VOLUME)), v5Out);
    UNIT_ASSERT_EQUAL(graph.GetInEdges(TGraph::TNode("v5", TGraph::ENodeType::VOLUME)), v5In);

    UNIT_ASSERT_EQUAL(graph.GetAllOutEdges(), allOut);
    UNIT_ASSERT_EQUAL(graph.GetAllInEdges(), allIn);
}

Y_UNIT_TEST(TestGraphRemoveEdge) {
    TGraph graph;

    const TSet<TGraph::TNode> v1Out = {TGraph::TNode("v3", TGraph::ENodeType::BOX)};
    const TSet<TGraph::TNode> v1In = {};
    const TSet<TGraph::TNode> v2Out = {};
    const TSet<TGraph::TNode> v2In = {};
    const TSet<TGraph::TNode> v3Out = {};
    const TSet<TGraph::TNode> v3In = {TGraph::TNode("v1", TGraph::ENodeType::WORKLOAD)};
    const TSet<TGraph::TNode> v4Out = {};
    const TSet<TGraph::TNode> v4In = {};
    const TSet<TGraph::TNode> v5Out = {};
    const TSet<TGraph::TNode> v5In = {};

    const TMap<TGraph::TNode, TSet<TGraph::TNode>> allOut = {
        {TGraph::TNode("v1", TGraph::ENodeType::WORKLOAD), v1Out}
    };

    const TMap<TGraph::TNode, TSet<TGraph::TNode>> allIn = {
        {TGraph::TNode("v3", TGraph::ENodeType::BOX), v3In}
    };

    graph.AddEdge(TGraph::TNode("v1", TGraph::ENodeType::WORKLOAD), TGraph::TNode("v2", TGraph::ENodeType::BOX));
    graph.AddEdge(TGraph::TNode("v1", TGraph::ENodeType::WORKLOAD), TGraph::TNode("v3", TGraph::ENodeType::BOX));
    graph.AddEdge(TGraph::TNode("v4", TGraph::ENodeType::WORKLOAD), TGraph::TNode("v2", TGraph::ENodeType::BOX));
    graph.AddEdge(TGraph::TNode("v2", TGraph::ENodeType::BOX), TGraph::TNode("v5", TGraph::ENodeType::VOLUME));

    graph.RemoveEdge(TGraph::TNode("v1", TGraph::ENodeType::WORKLOAD), TGraph::TNode("v2", TGraph::ENodeType::BOX));
    graph.RemoveEdge(TGraph::TNode("v2", TGraph::ENodeType::BOX), TGraph::TNode("v5", TGraph::ENodeType::VOLUME));
    graph.RemoveOutEdges(TGraph::TNode("v4", TGraph::ENodeType::WORKLOAD));

    UNIT_ASSERT(graph.GetInEdges(TGraph::TNode("none", TGraph::ENodeType::LAYER)).empty());
    UNIT_ASSERT(graph.GetOutEdges(TGraph::TNode("none", TGraph::ENodeType::LAYER)).empty());

    UNIT_ASSERT_EQUAL(graph.GetOutEdges(TGraph::TNode("v1", TGraph::ENodeType::WORKLOAD)), v1Out);
    UNIT_ASSERT_EQUAL(graph.GetInEdges(TGraph::TNode("v1", TGraph::ENodeType::WORKLOAD)), v1In);
    UNIT_ASSERT_EQUAL(graph.GetOutEdges(TGraph::TNode("v2", TGraph::ENodeType::BOX)), v2Out);
    UNIT_ASSERT_EQUAL(graph.GetInEdges(TGraph::TNode("v2", TGraph::ENodeType::BOX)), v2In);
    UNIT_ASSERT_EQUAL(graph.GetOutEdges(TGraph::TNode("v3", TGraph::ENodeType::BOX)), v3Out);
    UNIT_ASSERT_EQUAL(graph.GetInEdges(TGraph::TNode("v3", TGraph::ENodeType::BOX)), v3In);
    UNIT_ASSERT_EQUAL(graph.GetOutEdges(TGraph::TNode("v4", TGraph::ENodeType::WORKLOAD)), v4Out);
    UNIT_ASSERT_EQUAL(graph.GetInEdges(TGraph::TNode("v4", TGraph::ENodeType::WORKLOAD)), v4In);
    UNIT_ASSERT_EQUAL(graph.GetOutEdges(TGraph::TNode("v5", TGraph::ENodeType::VOLUME)), v5Out);
    UNIT_ASSERT_EQUAL(graph.GetInEdges(TGraph::TNode("v5", TGraph::ENodeType::VOLUME)), v5In);

    UNIT_ASSERT_EQUAL(graph.GetAllOutEdges(), allOut);
    UNIT_ASSERT_EQUAL(graph.GetAllInEdges(), allIn);
}


}

} // namespace NInfra::NPodAgent::NGraphTest
