#pragma once

#include "box_status_repository.h"
#include "layer_status_repository.h"
#include "static_resource_status_repository.h"
#include "volume_status_repository.h"
#include "workload_status_repository.h"

namespace NInfra::NPodAgent {

/**
    Thread-safe status repository
*/
class TStatusRepository: public TAtomicRefCount<TStatusRepository> {
public:
    TStatusRepository(
        TUpdateHolderPtr updateHolder
        , TBoxStatusRepositoryPtr boxStatusRepository
        , TLayerStatusRepositoryPtr layerStatusRepository
        , TStaticResourceStatusRepositoryPtr staticResourceStatusRepository
        , TVolumeStatusRepositoryPtr volumeStatusRepository
        , TWorkloadStatusRepositoryPtr workloadStatusRepository
    )
        : UpdateHolder_(updateHolder)
        , BoxStatusRepository_(boxStatusRepository)
        , LayerStatusRepository_(layerStatusRepository)
        , StaticResourceStatusRepository_(staticResourceStatusRepository)
        , VolumeStatusRepository_(volumeStatusRepository)
        , WorkloadStatusRepository_(workloadStatusRepository)
    {
    }

    TUpdateHolderPtr GetUpdateHolder() const;

    TBoxStatusRepositoryPtr GetBoxStatusRepository() const;
    TLayerStatusRepositoryPtr GetLayerStatusRepository() const;
    TStaticResourceStatusRepositoryPtr GetStaticResourceStatusRepository() const;
    TVolumeStatusRepositoryPtr GetVolumeStatusRepository() const;
    TWorkloadStatusRepositoryPtr GetWorkloadStatusRepository() const;

    // Total status
    void SetSpecTimestamp(ui64 specTimestamp);
    void SetRevision(ui32 revision);
    void SetSpecId(const TString& id);
    void SetTargetState(const API::EPodAgentTargetState targetState);
    API::EPodAgentTargetState GetTargetState() const;

    TString GetSpecId() const;

    API::TPodAgentStatus GetTotalStatus(bool conditionsOnly);

private:
    void PushConditionSignals(const API::TPodAgentStatus& status);

private:
    // Total status
    ui64 SpecTimestamp_ = 0;
    ui32 Revision_ = 0;
    TString SpecId_ = "";
    API::EPodAgentTargetState TargetState_ = API::EPodAgentTargetState_UNKNOWN;
    TLightRWLock TotalStatusLock_;

    TUpdateHolderPtr UpdateHolder_;

    TBoxStatusRepositoryPtr BoxStatusRepository_;
    TLayerStatusRepositoryPtr LayerStatusRepository_;
    TStaticResourceStatusRepositoryPtr StaticResourceStatusRepository_;
    TVolumeStatusRepositoryPtr VolumeStatusRepository_;
    TWorkloadStatusRepositoryPtr WorkloadStatusRepository_;
};

using TStatusRepositoryPtr = TIntrusivePtr<TStatusRepository>;

} // namespace NInfra::NPodAgent
