#include "support_functions.h"

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>
#include <util/string/builder.h>

namespace NInfra::NPodAgent::NSupport::NSupportFunctionsTest {

Y_UNIT_TEST_SUITE(SupportFunctionsSuite) {

Y_UNIT_TEST(TruncateTest) {
    TString shortString = "Hello world";
    TString maxSizeString = TString(2 * MAX_TRUNCATE_SIZE + 3, 'a');
    TString longString = TString(2 * MAX_TRUNCATE_SIZE + 4, 'a');
    TString veryLongString = TString(2 * MAX_TRUNCATE_SIZE + 5000, 'a');

    TString longStringAfterTruncate = TString(2 * MAX_TRUNCATE_SIZE + 3, 'a');
    longStringAfterTruncate[MAX_TRUNCATE_SIZE] = '.';
    longStringAfterTruncate[MAX_TRUNCATE_SIZE + 1] = '.';
    longStringAfterTruncate[MAX_TRUNCATE_SIZE + 2] = '.';

    UNIT_ASSERT_EQUAL_C(Truncate(shortString), shortString, Truncate(shortString));
    UNIT_ASSERT_EQUAL_C(Truncate(maxSizeString), maxSizeString, Truncate(maxSizeString));
    UNIT_ASSERT_EQUAL_C(Truncate(longString), longStringAfterTruncate, Truncate(longString));
    UNIT_ASSERT_EQUAL_C(Truncate(veryLongString), longStringAfterTruncate, Truncate(veryLongString));
}

Y_UNIT_TEST(ExtractStateTest) {
    TString stringWithoutUnderline = "ESomeRandomStringState";
    TString stringWithoutE = "State_CUSTOM";
    TString notState = "ECondition_FAILURE";
    TString anotherNotState = "E_BOY";
    TString correctState = API::ELayerState_Name((API::ELayerState_READY));

    UNIT_ASSERT_EXCEPTION_CONTAINS(ExtractState(stringWithoutUnderline), yexception, TStringBuilder() << "cannot find _ in '" << stringWithoutUnderline << "'");
    UNIT_ASSERT_EXCEPTION_CONTAINS(ExtractState(stringWithoutE), yexception, TStringBuilder() << "first character of '" << stringWithoutE <<"' is not equal to E");
    UNIT_ASSERT_EXCEPTION_CONTAINS(ExtractState(notState), yexception, TStringBuilder() << "cannot find 'State' before underline in '" << notState << "'");
    UNIT_ASSERT_EXCEPTION_CONTAINS(ExtractState(anotherNotState), yexception, TStringBuilder() << "cannot find 'State' before underline in '" << anotherNotState << "'");
    UNIT_ASSERT_EQUAL_C(ExtractState(correctState), "READY", ExtractState(correctState));
}

}

} // NInfra::NPodAgent::NSupport::NSupportFunctionsTest
