#pragma once

#include "status_repository_common.h"

#include <infra/pod_agent/libs/pod_agent/status_repository/types/status_repository_types.h>

namespace NInfra::NPodAgent {

void TestNetworkHooksAllTypes(std::function<void(NStatusRepositoryTypes::ENetworkHookType, NStatusRepositoryTypes::EHookBackend)> callback);

void TestHttpHookAllTypes(std::function<void(NStatusRepositoryTypes::ENetworkHookType)> callback);

void TestTcpHookAllTypes(std::function<void(NStatusRepositoryTypes::ENetworkHookType)> callback);

void TestWorkloadContainerHookAllTypes(std::function<void(NStatusRepositoryTypes::TContainerDescription::EContainerType)> callback);

API::TContainerStatus GetWorkloadContainerHookStatus(const API::TWorkloadStatus& status, NStatusRepositoryTypes::TContainerDescription::EContainerType container);

API::THttpGetStatus GetHttpHookStatus(const API::TWorkloadStatus& status, NStatusRepositoryTypes::ENetworkHookType type);

API::TTcpCheckStatus GetTcpCheckStatus(const API::TWorkloadStatus& status, NStatusRepositoryTypes::ENetworkHookType type);

API::TUnixSignalStatus GetStopUnixSignalStatus(const API::TWorkloadStatus& status);

} // namespace NInfra::NPodAgent
