#pragma once

#include <util/generic/string.h>
#include <util/generic/yexception.h>

namespace NInfra::NPodAgent::NStatusRepositoryTypes {

enum EObjectType {
    STATIC_RESOURCE   /* "static_resource" */,
    LAYER             /* "layer" */,
    VOLUME            /* "volume"   */,
    BOX               /* "box" */,
    WORKLOAD          /* "workload" */,
};

enum ENetworkHookType {
    READINESS    /* "readiness" */,
    LIVENESS     /* "liveness" */,
    STOP         /* "stop" */,
    DESTROY      /* "destroy" */
};

enum class EHookBackend {
    CONTAINER    /* "container" */,
    HTTP         /* "http" */,
    TCP          /* "tcp" */,
    UNIX_SIGNAL  /* "unix_signal" */,
    NO_HOOK      /* "no_hook" */
};

//NStatusRepositoryTypes::TContainerDescription stores information about the container position in StatusRepository
// To specify in the json tree that the container belongs to workload (or any other object type)
// You need to specify the following properties:
// "object_type": "workload"        (EObjectTypes)
// "container_type": "readiness"    (TContainerDescription::EContainerType)
// "object_id_or_hash":             object "id" or "hash"

struct TContainerDescription {
    enum EContainerType {
        META       /* "meta" */,
        INIT       /* "init" */,

        DOWNLOAD   /* "download" */,
        VERIFY     /* "verify" */,

        START      /* "start" */,
        STOP       /* "stop" */,
        DESTROY    /* "destroy" */,
        READINESS  /* "readiness" */,
        LIVENESS   /* "liveness" */,
    };

   TContainerDescription(
        const TString objectIdOrHash
        , EObjectType objectType
        , EContainerType containerType
    )
        : ObjectIdOrHash_(objectIdOrHash)
        , ObjectType_(objectType)
        , ContainerType_(containerType)
        , InitNum_(0)
    {
        Y_ENSURE(containerType != INIT, "trying to create init container without specifying InitNum_");
    }

   TContainerDescription(
        const TString& objectIdOrHash
        , EObjectType objectType
        , EContainerType containerType
        , size_t initNum
    )
        : ObjectIdOrHash_(objectIdOrHash)
        , ObjectType_(objectType)
        , ContainerType_(containerType)
        , InitNum_(initNum)
    {
        Y_ENSURE(containerType == INIT, "trying to create non init container with specified initNum");
    }

    const TString ObjectIdOrHash_;
    const EObjectType ObjectType_;
    const EContainerType ContainerType_;
    const size_t InitNum_;
};

} // namespace NInfra::NPodAgent::NStatusRepositoryTypes
