#pragma once

#include "container_status_internal.h"

#include <infra/pod_agent/libs/pod_agent/status_repository/status_repository_common.h>
#include <util/generic/map.h>

namespace NInfra::NPodAgent {

class TContainerStatusHolderInternal {
public:
    TContainerStatusHolderInternal() = default;

    TContainerStatusInternal& GetObjectContainerStatus(const NStatusRepositoryTypes::TContainerDescription& container) {
        if (container.ContainerType_ == NStatusRepositoryTypes::TContainerDescription::EContainerType::INIT) {
            return ObjectInitContainersStatus_[container.InitNum_];
        } else {
            return ObjectContainersStatus_[container.ContainerType_];
        }
    }

    const TContainerStatusInternal& GetObjectContainerStatus(const NStatusRepositoryTypes::TContainerDescription& container) const {
        static const TContainerStatusInternal emptyStatus;
        if (container.ContainerType_ == NStatusRepositoryTypes::TContainerDescription::EContainerType::INIT) {
            auto ptr = ObjectInitContainersStatus_.FindPtr(container.InitNum_);
            if (ptr) {
                return *ptr;
            } else {
                return emptyStatus;
            }
        } else {
            auto ptr = ObjectContainersStatus_.FindPtr(container.ContainerType_);
            if (ptr) {
                return *ptr;
            } else {
                return emptyStatus;
            }
        }
    }

private:
    THashMap<NStatusRepositoryTypes::TContainerDescription::EContainerType, TContainerStatusInternal> ObjectContainersStatus_;
    THashMap<ui32, TContainerStatusInternal> ObjectInitContainersStatus_;
};

} // namespace NInfra::NPodAgent
