#include "container_status_internal.h"

namespace NInfra::NPodAgent {

void TContainerStatusInternal::SetStartTime(const TInstant& time) {
    StartTime_ = time;
}

void TContainerStatusInternal::IncrementZeroReturnCodeCounter() {
    ++ZeroReturnCodeCounter_;
    ++ConsecutiveSuccessesCounter_;
    ConsecutiveFailuresCounter_ = 0;
}

void TContainerStatusInternal::IncrementPositiveReturnCodeCounter() {
    ++PositiveReturnCodeCounter_;
    ConsecutiveSuccessesCounter_ = 0;
    ++ConsecutiveFailuresCounter_;
}

void TContainerStatusInternal::IncrementOomCounter() {
    ++OomCounter_;
    ConsecutiveSuccessesCounter_ = 0;
    ++ConsecutiveFailuresCounter_;
}

void TContainerStatusInternal::IncrementKilledExternallyCounter() {
    ++KilledExternallyCounter_;
    ConsecutiveSuccessesCounter_ = 0;
    ++ConsecutiveFailuresCounter_;
}

TInstant TContainerStatusInternal::GetStartTime() const {
    return StartTime_;
}

ui32 TContainerStatusInternal::GetZeroReturnCodeCounter() const {
    return ZeroReturnCodeCounter_;
}

ui32 TContainerStatusInternal::GetPositiveReturnCodeCounter() const {
    return PositiveReturnCodeCounter_;
}

ui32 TContainerStatusInternal::GetOomCounter() const {
    return OomCounter_;
}

ui32 TContainerStatusInternal::GetKilledExternallyCounter() const {
    return KilledExternallyCounter_;
}

ui32 TContainerStatusInternal::GetConsecutiveSuccessesCounter() const {
    return ConsecutiveSuccessesCounter_;
}

ui32 TContainerStatusInternal::GetConsecutiveFailuresCounter() const {
    return ConsecutiveFailuresCounter_;
}

} // namespace NInfra::NPodAgent
