#pragma once

#include <util/datetime/base.h>

namespace NInfra::NPodAgent {

class TContainerStatusInternal {
public:
    TContainerStatusInternal()
        : StartTime_(TInstant::Zero())
        , ZeroReturnCodeCounter_(0)
        , PositiveReturnCodeCounter_(0)
        , OomCounter_(0)
        , KilledExternallyCounter_(0)
        , ConsecutiveSuccessesCounter_(0)
        , ConsecutiveFailuresCounter_(0)
    {
    }

    void SetStartTime(const TInstant& time);
    void IncrementZeroReturnCodeCounter();
    void IncrementPositiveReturnCodeCounter();
    void IncrementOomCounter();
    void IncrementKilledExternallyCounter();

    TInstant GetStartTime() const;
    ui32 GetZeroReturnCodeCounter() const;
    ui32 GetPositiveReturnCodeCounter() const;
    ui32 GetOomCounter() const;
    ui32 GetKilledExternallyCounter() const;
    ui32 GetConsecutiveSuccessesCounter() const;
    ui32 GetConsecutiveFailuresCounter() const;

private:
    TInstant StartTime_;
    ui32 ZeroReturnCodeCounter_;
    ui32 PositiveReturnCodeCounter_;
    ui32 OomCounter_;
    ui32 KilledExternallyCounter_;
    ui32 ConsecutiveSuccessesCounter_;
    ui32 ConsecutiveFailuresCounter_;
};

} // namespace NInfra::NPodAgent
