#include "container_status_internal.h"

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

namespace NInfra::NPodAgent::NContainerStatusInternalTest {

Y_UNIT_TEST_SUITE(ContainerStatusInternalSuite) {

Y_UNIT_TEST(TestStartTime) {
    TContainerStatusInternal containerStatus;

    UNIT_ASSERT_EQUAL_C(containerStatus.GetStartTime(), TInstant::Zero(), containerStatus.GetStartTime());
    containerStatus.SetStartTime(TInstant::Max());
    UNIT_ASSERT_EQUAL_C(containerStatus.GetStartTime(), TInstant::Max(), containerStatus.GetStartTime());
}

Y_UNIT_TEST(TestCounters) {
    const size_t cntIter = 10;
    TContainerStatusInternal containerStatus;

    UNIT_ASSERT_EQUAL_C(containerStatus.GetZeroReturnCodeCounter(), 0, containerStatus.GetZeroReturnCodeCounter());
    UNIT_ASSERT_EQUAL_C(containerStatus.GetPositiveReturnCodeCounter(), 0, containerStatus.GetPositiveReturnCodeCounter());
    UNIT_ASSERT_EQUAL_C(containerStatus.GetOomCounter(), 0, containerStatus.GetOomCounter());
    UNIT_ASSERT_EQUAL_C(containerStatus.GetKilledExternallyCounter(), 0, containerStatus.GetKilledExternallyCounter());
    UNIT_ASSERT_EQUAL_C(containerStatus.GetConsecutiveSuccessesCounter(), 0, containerStatus.GetConsecutiveSuccessesCounter());
    UNIT_ASSERT_EQUAL_C(containerStatus.GetConsecutiveFailuresCounter(), 0, containerStatus.GetConsecutiveFailuresCounter());

    for (size_t i = 0; i < cntIter; ++i) {
        containerStatus.IncrementZeroReturnCodeCounter();

        UNIT_ASSERT_EQUAL_C(containerStatus.GetZeroReturnCodeCounter(), i + 1, containerStatus.GetZeroReturnCodeCounter());
        UNIT_ASSERT_EQUAL_C(containerStatus.GetPositiveReturnCodeCounter(), 0, containerStatus.GetPositiveReturnCodeCounter());
        UNIT_ASSERT_EQUAL_C(containerStatus.GetOomCounter(), 0, containerStatus.GetOomCounter());
        UNIT_ASSERT_EQUAL_C(containerStatus.GetKilledExternallyCounter(), 0, containerStatus.GetKilledExternallyCounter());
        UNIT_ASSERT_EQUAL_C(containerStatus.GetConsecutiveSuccessesCounter(), i + 1, containerStatus.GetConsecutiveSuccessesCounter());
        UNIT_ASSERT_EQUAL_C(containerStatus.GetConsecutiveFailuresCounter(), 0, containerStatus.GetConsecutiveFailuresCounter());
    }

    for (size_t i = 0; i < cntIter; ++i) {
        containerStatus.IncrementPositiveReturnCodeCounter();

        UNIT_ASSERT_EQUAL_C(containerStatus.GetZeroReturnCodeCounter(), cntIter, containerStatus.GetZeroReturnCodeCounter());
        UNIT_ASSERT_EQUAL_C(containerStatus.GetPositiveReturnCodeCounter(), i + 1, containerStatus.GetPositiveReturnCodeCounter());
        UNIT_ASSERT_EQUAL_C(containerStatus.GetOomCounter(), 0, containerStatus.GetOomCounter());
        UNIT_ASSERT_EQUAL_C(containerStatus.GetKilledExternallyCounter(), 0, containerStatus.GetKilledExternallyCounter());
        UNIT_ASSERT_EQUAL_C(containerStatus.GetConsecutiveSuccessesCounter(), 0, containerStatus.GetConsecutiveSuccessesCounter());
        UNIT_ASSERT_EQUAL_C(containerStatus.GetConsecutiveFailuresCounter(), i + 1, containerStatus.GetConsecutiveFailuresCounter());
    }

    for (size_t i = 0; i < cntIter; ++i) {
        containerStatus.IncrementOomCounter();

        UNIT_ASSERT_EQUAL_C(containerStatus.GetZeroReturnCodeCounter(), cntIter, containerStatus.GetZeroReturnCodeCounter());
        UNIT_ASSERT_EQUAL_C(containerStatus.GetPositiveReturnCodeCounter(), cntIter, containerStatus.GetPositiveReturnCodeCounter());
        UNIT_ASSERT_EQUAL_C(containerStatus.GetOomCounter(), i + 1, containerStatus.GetOomCounter());
        UNIT_ASSERT_EQUAL_C(containerStatus.GetKilledExternallyCounter(), 0, containerStatus.GetKilledExternallyCounter());
        UNIT_ASSERT_EQUAL_C(containerStatus.GetConsecutiveSuccessesCounter(), 0, containerStatus.GetConsecutiveSuccessesCounter());
        UNIT_ASSERT_EQUAL_C(containerStatus.GetConsecutiveFailuresCounter(), cntIter + i + 1, containerStatus.GetConsecutiveFailuresCounter());
    }

    for (size_t i = 0; i < cntIter; ++i) {
        containerStatus.IncrementKilledExternallyCounter();

        UNIT_ASSERT_EQUAL_C(containerStatus.GetZeroReturnCodeCounter(), cntIter, containerStatus.GetZeroReturnCodeCounter());
        UNIT_ASSERT_EQUAL_C(containerStatus.GetPositiveReturnCodeCounter(), cntIter, containerStatus.GetPositiveReturnCodeCounter());
        UNIT_ASSERT_EQUAL_C(containerStatus.GetOomCounter(), cntIter, containerStatus.GetOomCounter());
        UNIT_ASSERT_EQUAL_C(containerStatus.GetKilledExternallyCounter(), i + 1, containerStatus.GetKilledExternallyCounter());
        UNIT_ASSERT_EQUAL_C(containerStatus.GetConsecutiveSuccessesCounter(), 0, containerStatus.GetConsecutiveSuccessesCounter());
        UNIT_ASSERT_EQUAL_C(containerStatus.GetConsecutiveFailuresCounter(), 2 * cntIter + i + 1, containerStatus.GetConsecutiveFailuresCounter());
    }
}

}

}; // namespace NInfra::NPodAgent::NContainerStatusInternalTest
