#include "container_status_repository_internal.h"

namespace NInfra::NPodAgent {

void IContainerStatusRepositoryInternal::SetContainerStartTime(const NStatusRepositoryTypes::TContainerDescription& container, const TInstant& time) {
    TReadGuardBase<TLightRWLock> guard(GlobalLock_);
    TGuard<TMutex> g(GetContainerMutex(container));

    TContainerStatusInternal& containerStatus = GetContainerStatus(container);
    containerStatus.SetStartTime(time);
}

void IContainerStatusRepositoryInternal::IncrementContainerZeroReturnCodeCounter(const NStatusRepositoryTypes::TContainerDescription& container) {
    TReadGuardBase<TLightRWLock> guard(GlobalLock_);
    TGuard<TMutex> g(GetContainerMutex(container));

    TContainerStatusInternal& containerStatus = GetContainerStatus(container);
    containerStatus.IncrementZeroReturnCodeCounter();
}

void IContainerStatusRepositoryInternal::IncrementContainerPositiveReturnCodeCounter(const NStatusRepositoryTypes::TContainerDescription& container) {
    TReadGuardBase<TLightRWLock> guard(GlobalLock_);
    TGuard<TMutex> g(GetContainerMutex(container));

    TContainerStatusInternal& containerStatus = GetContainerStatus(container);
    containerStatus.IncrementPositiveReturnCodeCounter();
}

void IContainerStatusRepositoryInternal::IncrementContainerOomCounter(const NStatusRepositoryTypes::TContainerDescription& container) {
    TReadGuardBase<TLightRWLock> guard(GlobalLock_);
    TGuard<TMutex> g(GetContainerMutex(container));

    TContainerStatusInternal& containerStatus = GetContainerStatus(container);
    containerStatus.IncrementOomCounter();
}

void IContainerStatusRepositoryInternal::IncrementContainerKilledExternallyCounter(const NStatusRepositoryTypes::TContainerDescription& container) {
    TReadGuardBase<TLightRWLock> guard(GlobalLock_);
    TGuard<TMutex> g(GetContainerMutex(container));

    TContainerStatusInternal& containerStatus = GetContainerStatus(container);
    containerStatus.IncrementKilledExternallyCounter();
}

TInstant IContainerStatusRepositoryInternal::GetContainerStartTime(const NStatusRepositoryTypes::TContainerDescription& container) const {
    TReadGuardBase<TLightRWLock> guard(GlobalLock_);
    TGuard<TMutex> g(GetContainerMutex(container));

    const TContainerStatusInternal& containerStatus = GetContainerStatus(container);
    return containerStatus.GetStartTime();
}

ui32 IContainerStatusRepositoryInternal::GetContainerZeroReturnCodeCounter(const NStatusRepositoryTypes::TContainerDescription& container) const {
    TReadGuardBase<TLightRWLock> guard(GlobalLock_);
    TGuard<TMutex> g(GetContainerMutex(container));

    const TContainerStatusInternal& containerStatus = GetContainerStatus(container);
    return containerStatus.GetZeroReturnCodeCounter();
}

ui32 IContainerStatusRepositoryInternal::GetContainerPositiveReturnCodeCounter(const NStatusRepositoryTypes::TContainerDescription& container) const {
    TReadGuardBase<TLightRWLock> guard(GlobalLock_);
    TGuard<TMutex> g(GetContainerMutex(container));

    const TContainerStatusInternal& containerStatus = GetContainerStatus(container);
    return containerStatus.GetPositiveReturnCodeCounter();
}

ui32 IContainerStatusRepositoryInternal::GetContainerOomCounter(const NStatusRepositoryTypes::TContainerDescription& container) const {
    TReadGuardBase<TLightRWLock> guard(GlobalLock_);
    TGuard<TMutex> g(GetContainerMutex(container));

    const TContainerStatusInternal& containerStatus = GetContainerStatus(container);
    return containerStatus.GetOomCounter();
}

ui32 IContainerStatusRepositoryInternal::GetContainerKilledExternallyCounter(const NStatusRepositoryTypes::TContainerDescription& container) const {
    TReadGuardBase<TLightRWLock> guard(GlobalLock_);
    TGuard<TMutex> g(GetContainerMutex(container));

    const TContainerStatusInternal& containerStatus = GetContainerStatus(container);
    return containerStatus.GetKilledExternallyCounter();
}

ui32 IContainerStatusRepositoryInternal::GetContainerConsecutiveSuccessesCounter(const NStatusRepositoryTypes::TContainerDescription& container) const {
    TReadGuardBase<TLightRWLock> guard(GlobalLock_);
    TGuard<TMutex> g(GetContainerMutex(container));

    const TContainerStatusInternal& containerStatus = GetContainerStatus(container);
    return containerStatus.GetConsecutiveSuccessesCounter();
}

ui32 IContainerStatusRepositoryInternal::GetContainerConsecutiveFailuresCounter(const NStatusRepositoryTypes::TContainerDescription& container) const {
    TReadGuardBase<TLightRWLock> guard(GlobalLock_);
    TGuard<TMutex> g(GetContainerMutex(container));

    const TContainerStatusInternal& containerStatus = GetContainerStatus(container);
    return containerStatus.GetConsecutiveFailuresCounter();
}

} // namespace NInfra::NPodAgent
