#pragma once
#include "container_status_internal.h"

#include <infra/pod_agent/libs/pod_agent/status_repository/status_repository_common.h>

#include <library/cpp/threading/light_rw_lock/lightrwlock.h>

#include <util/system/mutex.h>

namespace NInfra::NPodAgent {

class IContainerStatusRepositoryInternal: public TAtomicRefCount<IContainerStatusRepositoryInternal> {
public:
    IContainerStatusRepositoryInternal() = default;
    virtual ~IContainerStatusRepositoryInternal() = default;

    void SetContainerStartTime(const NStatusRepositoryTypes::TContainerDescription& container, const TInstant& time);
    void IncrementContainerZeroReturnCodeCounter(const NStatusRepositoryTypes::TContainerDescription& container);
    void IncrementContainerPositiveReturnCodeCounter(const NStatusRepositoryTypes::TContainerDescription& container);
    void IncrementContainerOomCounter(const NStatusRepositoryTypes::TContainerDescription& container);
    void IncrementContainerKilledExternallyCounter(const NStatusRepositoryTypes::TContainerDescription& container);

    TInstant GetContainerStartTime(const NStatusRepositoryTypes::TContainerDescription& container) const;
    ui32 GetContainerZeroReturnCodeCounter(const NStatusRepositoryTypes::TContainerDescription& container) const;
    ui32 GetContainerPositiveReturnCodeCounter(const NStatusRepositoryTypes::TContainerDescription& container) const;
    ui32 GetContainerOomCounter(const NStatusRepositoryTypes::TContainerDescription& container) const;
    ui32 GetContainerKilledExternallyCounter(const NStatusRepositoryTypes::TContainerDescription& container) const;
    ui32 GetContainerConsecutiveSuccessesCounter(const NStatusRepositoryTypes::TContainerDescription& container) const;
    ui32 GetContainerConsecutiveFailuresCounter(const NStatusRepositoryTypes::TContainerDescription& container) const;

protected:
    virtual TContainerStatusInternal& GetContainerStatus(const NStatusRepositoryTypes::TContainerDescription& container) = 0;
    virtual const TContainerStatusInternal& GetContainerStatus(const NStatusRepositoryTypes::TContainerDescription& container) const = 0;
    virtual const TMutex& GetContainerMutex(const NStatusRepositoryTypes::TContainerDescription& container) const = 0;

protected:
    TLightRWLock GlobalLock_;
};

using TContainerStatusRepositoryInternalPtr = TIntrusivePtr<IContainerStatusRepositoryInternal>;

} // namespace NInfra::NPodAgent
